/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.trunking.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class TrunkUpdater extends Updater<Trunk> {
    private final String pathSid;
    private String friendlyName;
    private String domainName;
    private URI disasterRecoveryUrl;
    private HttpMethod disasterRecoveryMethod;
    private String recording;
    private Boolean secure;

    /**
     * Construct a new TrunkUpdater.
     * 
     * @param pathSid The sid
     */
    public TrunkUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * The friendly_name.
     * 
     * @param friendlyName The friendly_name
     * @return this
     */
    public TrunkUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The domain_name.
     * 
     * @param domainName The domain_name
     * @return this
     */
    public TrunkUpdater setDomainName(final String domainName) {
        this.domainName = domainName;
        return this;
    }

    /**
     * The disaster_recovery_url.
     * 
     * @param disasterRecoveryUrl The disaster_recovery_url
     * @return this
     */
    public TrunkUpdater setDisasterRecoveryUrl(final URI disasterRecoveryUrl) {
        this.disasterRecoveryUrl = disasterRecoveryUrl;
        return this;
    }

    /**
     * The disaster_recovery_url.
     * 
     * @param disasterRecoveryUrl The disaster_recovery_url
     * @return this
     */
    public TrunkUpdater setDisasterRecoveryUrl(final String disasterRecoveryUrl) {
        return setDisasterRecoveryUrl(Promoter.uriFromString(disasterRecoveryUrl));
    }

    /**
     * The disaster_recovery_method.
     * 
     * @param disasterRecoveryMethod The disaster_recovery_method
     * @return this
     */
    public TrunkUpdater setDisasterRecoveryMethod(final HttpMethod disasterRecoveryMethod) {
        this.disasterRecoveryMethod = disasterRecoveryMethod;
        return this;
    }

    /**
     * The recording.
     * 
     * @param recording The recording
     * @return this
     */
    public TrunkUpdater setRecording(final String recording) {
        this.recording = recording;
        return this;
    }

    /**
     * The secure.
     * 
     * @param secure The secure
     * @return this
     */
    public TrunkUpdater setSecure(final Boolean secure) {
        this.secure = secure;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     * 
     * @param client TwilioRestClient with which to make the request
     * @return Updated Trunk
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Trunk update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUNKING.toString(),
            "/v1/Trunks/" + this.pathSid + "",
            client.getRegion()
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Trunk update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }

            throw new ApiException(
                restException.getMessage(),
                restException.getCode(),
                restException.getMoreInfo(),
                restException.getStatus(),
                null
            );
        }

        return Trunk.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     * 
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (domainName != null) {
            request.addPostParam("DomainName", domainName);
        }

        if (disasterRecoveryUrl != null) {
            request.addPostParam("DisasterRecoveryUrl", disasterRecoveryUrl.toString());
        }

        if (disasterRecoveryMethod != null) {
            request.addPostParam("DisasterRecoveryMethod", disasterRecoveryMethod.toString());
        }

        if (recording != null) {
            request.addPostParam("Recording", recording);
        }

        if (secure != null) {
            request.addPostParam("Secure", secure.toString());
        }
    }
}