/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.wireless.v1.sim;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import org.joda.time.DateTime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DataSession extends Resource {
    private static final long serialVersionUID = 147675841254752L;

    /**
     * Create a DataSessionReader to execute read.
     * 
     * @param pathSimSid The sim_sid
     * @return DataSessionReader capable of executing the read
     */
    public static DataSessionReader reader(final String pathSimSid) {
        return new DataSessionReader(pathSimSid);
    }

    /**
     * Converts a JSON String into a DataSession object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return DataSession object represented by the provided JSON
     */
    public static DataSession fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, DataSession.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a DataSession object using the provided
     * ObjectMapper.
     * 
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return DataSession object represented by the provided JSON
     */
    public static DataSession fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, DataSession.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String simSid;
    private final String accountSid;
    private final String radioLink;
    private final String operatorMcc;
    private final String operatorMnc;
    private final String operatorCountry;
    private final String operatorName;
    private final String cellId;
    private final Map<String, Object> cellLocationEstimate;
    private final Integer packetsUploaded;
    private final Integer packetsDownloaded;
    private final DateTime lastUpdated;
    private final DateTime start;
    private final DateTime end;

    @JsonCreator
    private DataSession(@JsonProperty("sid")
                        final String sid, 
                        @JsonProperty("sim_sid")
                        final String simSid, 
                        @JsonProperty("account_sid")
                        final String accountSid, 
                        @JsonProperty("radio_link")
                        final String radioLink, 
                        @JsonProperty("operator_mcc")
                        final String operatorMcc, 
                        @JsonProperty("operator_mnc")
                        final String operatorMnc, 
                        @JsonProperty("operator_country")
                        final String operatorCountry, 
                        @JsonProperty("operator_name")
                        final String operatorName, 
                        @JsonProperty("cell_id")
                        final String cellId, 
                        @JsonProperty("cell_location_estimate")
                        final Map<String, Object> cellLocationEstimate, 
                        @JsonProperty("packets_uploaded")
                        final Integer packetsUploaded, 
                        @JsonProperty("packets_downloaded")
                        final Integer packetsDownloaded, 
                        @JsonProperty("last_updated")
                        final String lastUpdated, 
                        @JsonProperty("start")
                        final String start, 
                        @JsonProperty("end")
                        final String end) {
        this.sid = sid;
        this.simSid = simSid;
        this.accountSid = accountSid;
        this.radioLink = radioLink;
        this.operatorMcc = operatorMcc;
        this.operatorMnc = operatorMnc;
        this.operatorCountry = operatorCountry;
        this.operatorName = operatorName;
        this.cellId = cellId;
        this.cellLocationEstimate = cellLocationEstimate;
        this.packetsUploaded = packetsUploaded;
        this.packetsDownloaded = packetsDownloaded;
        this.lastUpdated = DateConverter.iso8601DateTimeFromString(lastUpdated);
        this.start = DateConverter.iso8601DateTimeFromString(start);
        this.end = DateConverter.iso8601DateTimeFromString(end);
    }

    /**
     * Returns The The sid.
     * 
     * @return The sid
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The The sim_sid.
     * 
     * @return The sim_sid
     */
    public final String getSimSid() {
        return this.simSid;
    }

    /**
     * Returns The The account_sid.
     * 
     * @return The account_sid
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The The radio_link.
     * 
     * @return The radio_link
     */
    public final String getRadioLink() {
        return this.radioLink;
    }

    /**
     * Returns The The operator_mcc.
     * 
     * @return The operator_mcc
     */
    public final String getOperatorMcc() {
        return this.operatorMcc;
    }

    /**
     * Returns The The operator_mnc.
     * 
     * @return The operator_mnc
     */
    public final String getOperatorMnc() {
        return this.operatorMnc;
    }

    /**
     * Returns The The operator_country.
     * 
     * @return The operator_country
     */
    public final String getOperatorCountry() {
        return this.operatorCountry;
    }

    /**
     * Returns The The operator_name.
     * 
     * @return The operator_name
     */
    public final String getOperatorName() {
        return this.operatorName;
    }

    /**
     * Returns The The cell_id.
     * 
     * @return The cell_id
     */
    public final String getCellId() {
        return this.cellId;
    }

    /**
     * Returns The The cell_location_estimate.
     * 
     * @return The cell_location_estimate
     */
    public final Map<String, Object> getCellLocationEstimate() {
        return this.cellLocationEstimate;
    }

    /**
     * Returns The The packets_uploaded.
     * 
     * @return The packets_uploaded
     */
    public final Integer getPacketsUploaded() {
        return this.packetsUploaded;
    }

    /**
     * Returns The The packets_downloaded.
     * 
     * @return The packets_downloaded
     */
    public final Integer getPacketsDownloaded() {
        return this.packetsDownloaded;
    }

    /**
     * Returns The The last_updated.
     * 
     * @return The last_updated
     */
    public final DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    /**
     * Returns The The start.
     * 
     * @return The start
     */
    public final DateTime getStart() {
        return this.start;
    }

    /**
     * Returns The The end.
     * 
     * @return The end
     */
    public final DateTime getEnd() {
        return this.end;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DataSession other = (DataSession) o;

        return Objects.equals(sid, other.sid) && 
               Objects.equals(simSid, other.simSid) && 
               Objects.equals(accountSid, other.accountSid) && 
               Objects.equals(radioLink, other.radioLink) && 
               Objects.equals(operatorMcc, other.operatorMcc) && 
               Objects.equals(operatorMnc, other.operatorMnc) && 
               Objects.equals(operatorCountry, other.operatorCountry) && 
               Objects.equals(operatorName, other.operatorName) && 
               Objects.equals(cellId, other.cellId) && 
               Objects.equals(cellLocationEstimate, other.cellLocationEstimate) && 
               Objects.equals(packetsUploaded, other.packetsUploaded) && 
               Objects.equals(packetsDownloaded, other.packetsDownloaded) && 
               Objects.equals(lastUpdated, other.lastUpdated) && 
               Objects.equals(start, other.start) && 
               Objects.equals(end, other.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            simSid,
                            accountSid,
                            radioLink,
                            operatorMcc,
                            operatorMnc,
                            operatorCountry,
                            operatorName,
                            cellId,
                            cellLocationEstimate,
                            packetsUploaded,
                            packetsDownloaded,
                            lastUpdated,
                            start,
                            end);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("sid", sid)
                          .add("simSid", simSid)
                          .add("accountSid", accountSid)
                          .add("radioLink", radioLink)
                          .add("operatorMcc", operatorMcc)
                          .add("operatorMnc", operatorMnc)
                          .add("operatorCountry", operatorCountry)
                          .add("operatorName", operatorName)
                          .add("cellId", cellId)
                          .add("cellLocationEstimate", cellLocationEstimate)
                          .add("packetsUploaded", packetsUploaded)
                          .add("packetsDownloaded", packetsDownloaded)
                          .add("lastUpdated", lastUpdated)
                          .add("start", start)
                          .add("end", end)
                          .toString();
    }
}