/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml;

import com.twilio.twiml.messaging.Message;
import com.twilio.twiml.messaging.Redirect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Response>}
 */
public class MessagingResponse extends TwiML {
    /**
     * For XML Serialization/Deserialization
     */
    private MessagingResponse() {
        this(new Builder());
    }

    /**
     * Create a new {@code <MessagingResponse>} element
     */
    private MessagingResponse(Builder b) {
        super("Response", b.children, b.options);
    }

    /**
     * Create a new {@code <Response>} element
     */
    public static class Builder {
        private Map<String, String> options = new HashMap<>();
        private List<TwiML> children = new ArrayList<>();

        /**
         * Add a child {@code <Message>} element
         */
        public Builder message(Message message) {
            this.children.add(message);
            return this;
        }

        /**
         * Add a child {@code <Redirect>} element
         */
        public Builder redirect(Redirect redirect) {
            this.children.add(redirect);
            return this;
        }

        /**
         * Set additional attributes on this TwiML element that will appear in generated
         * XML.
         */
        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        /**
         * Create and return resulting {@code <Response>} element
         */
        public MessagingResponse build() {
            return new MessagingResponse(this);
        }
    }
}