/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.messaging;

import com.twilio.twiml.TwiML;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Body>}
 */
public class Body extends TwiML {
    private final String message;

    /**
     * For XML Serialization/Deserialization
     */
    private Body() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Body>} element
     */
    private Body(Builder b) {
        super("Body", Collections.<TwiML>emptyList(), b.options);
        this.message = b.message;
    }

    /**
     * The body of the TwiML element
     * 
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getMessage() == null ? null : this.getMessage();
    }

    /**
     * Message Body
     * 
     * @return Message Body
     */
    public String getMessage() {
        return message;
    }

    /**
     * Create a new {@code <Body>} element
     */
    public static class Builder {
        private String message;
        private Map<String, String> options = new HashMap<>();

        /**
         * Create a {@code <Body>} with message
         */
        public Builder(String message) {
            this.message = message;
        }

        /**
         * Set additional attributes on this TwiML element that will appear in generated
         * XML.
         */
        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        /**
         * Create and return resulting {@code <Body>} element
         */
        public Body build() {
            return new Body(this);
        }
    }
}