/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Enqueue>}
 */
public class Enqueue extends TwiML {
    private final URI action;
    private final HttpMethod method;
    private final URI waitUrl;
    private final HttpMethod waitUrlMethod;
    private final String workflowSid;
    private final String name;

    /**
     * For XML Serialization/Deserialization
     */
    private Enqueue() {
        this(new Builder());
    }

    /**
     * Create a new {@code <Enqueue>} element
     */
    private Enqueue(Builder b) {
        super("Enqueue", b.children, b.options);
        this.action = b.action;
        this.method = b.method;
        this.waitUrl = b.waitUrl;
        this.waitUrlMethod = b.waitUrlMethod;
        this.workflowSid = b.workflowSid;
        this.name = b.name;
    }

    /**
     * The body of the TwiML element
     * 
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    /**
     * Attributes to set on the generated XML element
     * 
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getWaitUrl() != null) {
            attrs.put("waitUrl", this.getWaitUrl().toString());
        }
        if (this.getWaitUrlMethod() != null) {
            attrs.put("waitUrlMethod", this.getWaitUrlMethod().toString());
        }
        if (this.getWorkflowSid() != null) {
            attrs.put("workflowSid", this.getWorkflowSid());
        }

        return attrs;
    }

    /**
     * Action URL
     * 
     * @return Action URL
     */
    public URI getAction() {
        return action;
    }

    /**
     * Action URL method
     * 
     * @return Action URL method
     */
    public HttpMethod getMethod() {
        return method;
    }

    /**
     * Wait URL
     * 
     * @return Wait URL
     */
    public URI getWaitUrl() {
        return waitUrl;
    }

    /**
     * Wait URL method
     * 
     * @return Wait URL method
     */
    public HttpMethod getWaitUrlMethod() {
        return waitUrlMethod;
    }

    /**
     * TaskRouter Workflow SID
     * 
     * @return TaskRouter Workflow SID
     */
    public String getWorkflowSid() {
        return workflowSid;
    }

    /**
     * Friendly name
     * 
     * @return Friendly name
     */
    public String getName() {
        return name;
    }

    /**
     * Create a new {@code <Enqueue>} element
     */
    public static class Builder {
        private URI action;
        private HttpMethod method;
        private URI waitUrl;
        private HttpMethod waitUrlMethod;
        private String workflowSid;
        private String name;
        private Map<String, String> options = new HashMap<>();
        private List<TwiML> children = new ArrayList<>();

        /**
         * Create a {@code <Enqueue>} with name
         */
        public Builder(String name) {
            this.name = name;
        }

        /**
         * Create a {@code <Enqueue>} with child elements
         */
        public Builder() {
        }

        /**
         * Action URL
         */
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        /**
         * Action URL
         */
        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        /**
         * Action URL method
         */
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Wait URL
         */
        public Builder waitUrl(URI waitUrl) {
            this.waitUrl = waitUrl;
            return this;
        }

        /**
         * Wait URL
         */
        public Builder waitUrl(String waitUrl) {
            this.waitUrl = Promoter.uriFromString(waitUrl);
            return this;
        }

        /**
         * Wait URL method
         */
        public Builder waitUrlMethod(HttpMethod waitUrlMethod) {
            this.waitUrlMethod = waitUrlMethod;
            return this;
        }

        /**
         * TaskRouter Workflow SID
         */
        public Builder workflowSid(String workflowSid) {
            this.workflowSid = workflowSid;
            return this;
        }

        /**
         * Friendly name
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Add a child {@code <Task>} element
         */
        public Builder task(Task task) {
            this.children.add(task);
            return this;
        }

        /**
         * Set additional attributes on this TwiML element that will appear in generated
         * XML.
         */
        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        /**
         * Create and return resulting {@code <Enqueue>} element
         */
        public Enqueue build() {
            return new Enqueue(this);
        }
    }
}