/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Gather>}
 */
public class Gather extends TwiML {
    public enum Input {
        DTMF("dtmf"),
        SPEECH("speech"),
        DTMF_SPEECH("dtmf_speech");

        private final String value;

        private Input(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    public enum Language {
        AF_ZA("af-ZA"),
        ID_ID("id-ID"),
        MS_MY("ms-MY"),
        CA_ES("ca-ES"),
        CS_CZ("cs-CZ"),
        DA_DK("da-DK"),
        DE_DE("de-DE"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_IE("en-IE"),
        EN_NZ("en-NZ"),
        EN_PH("en-PH"),
        EN_ZA("en-ZA"),
        EN_US("en-US"),
        ES_AR("es-AR"),
        ES_BO("es-BO"),
        ES_CL("es-CL"),
        ES_CO("es-CO"),
        ES_CR("es-CR"),
        ES_EC("es-EC"),
        ES_SV("es-SV"),
        ES_ES("es-ES"),
        ES_US("es-US"),
        ES_GT("es-GT"),
        ES_HN("es-HN"),
        ES_MX("es-MX"),
        ES_NI("es-NI"),
        ES_PA("es-PA"),
        ES_PY("es-PY"),
        ES_PE("es-PE"),
        ES_PR("es-PR"),
        ES_DO("es-DO"),
        ES_UY("es-UY"),
        ES_VE("es-VE"),
        EU_ES("eu-ES"),
        IL_PH("il-PH"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        GL_ES("gl-ES"),
        HR_HR("hr-HR"),
        ZU_ZA("zu-ZA"),
        IS_IS("is-IS"),
        IT_IT("it-IT"),
        LT_LT("lt-LT"),
        HU_HU("hu-HU"),
        NL_NL("nl-NL"),
        NB_NO("nb-NO"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RO_RO("ro-RO"),
        SK_SK("sk-SK"),
        SL_SI("sl-SI"),
        FI_FI("fi-FI"),
        SV_SE("sv-SE"),
        VI_VN("vi-VN"),
        TR_TR("tr-TR"),
        EL_GR("el-GR"),
        BG_BG("bg-BG"),
        RU_RU("ru-RU"),
        SR_RS("sr-RS"),
        UK_UA("uk-UA"),
        HE_IL("he-IL"),
        AR_IL("ar-IL"),
        AR_JO("ar-JO"),
        AR_AE("ar-AE"),
        AR_BH("ar-BH"),
        AR_DZ("ar-DZ"),
        AR_SA("ar-SA"),
        AR_IQ("ar-IQ"),
        AR_KW("ar-KW"),
        AR_MA("ar-MA"),
        AR_TN("ar-TN"),
        AR_OM("ar-OM"),
        AR_PS("ar-PS"),
        AR_QA("ar-QA"),
        AR_LB("ar-LB"),
        AR_EG("ar-EG"),
        FA_IR("fa-IR"),
        HI_IN("hi-IN"),
        TH_TH("th-TH"),
        KO_KR("ko-KR"),
        CMN_HANT_TW("cmn-Hant-TW"),
        YUE_HANT_HK("yue-Hant-HK"),
        JA_JP("ja-JP"),
        CMN_HANS_HK("cmn-Hans-HK"),
        CMN_HANS_CN("cmn-Hans-CN");

        private final String value;

        private Language(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final Gather.Input input;
    private final URI action;
    private final HttpMethod method;
    private final Integer timeout;
    private final String speechTimeout;
    private final Integer maxSpeechTime;
    private final Boolean profanityFilter;
    private final String finishOnKey;
    private final Integer numDigits;
    private final URI partialResultCallback;
    private final HttpMethod partialResultCallbackMethod;
    private final Gather.Language language;
    private final String hints;
    private final Boolean bargeIn;

    /**
     * For XML Serialization/Deserialization
     */
    private Gather() {
        this(new Builder());
    }

    /**
     * Create a new {@code <Gather>} element
     */
    private Gather(Builder b) {
        super("Gather", b.children, b.options);
        this.input = b.input;
        this.action = b.action;
        this.method = b.method;
        this.timeout = b.timeout;
        this.speechTimeout = b.speechTimeout;
        this.maxSpeechTime = b.maxSpeechTime;
        this.profanityFilter = b.profanityFilter;
        this.finishOnKey = b.finishOnKey;
        this.numDigits = b.numDigits;
        this.partialResultCallback = b.partialResultCallback;
        this.partialResultCallbackMethod = b.partialResultCallbackMethod;
        this.language = b.language;
        this.hints = b.hints;
        this.bargeIn = b.bargeIn;
    }

    /**
     * Attributes to set on the generated XML element
     * 
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getInput() != null) {
            attrs.put("input", this.getInput().toString());
        }
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        if (this.getSpeechTimeout() != null) {
            attrs.put("speechTimeout", this.getSpeechTimeout());
        }
        if (this.getMaxSpeechTime() != null) {
            attrs.put("maxSpeechTime", this.getMaxSpeechTime().toString());
        }
        if (this.isProfanityFilter() != null) {
            attrs.put("profanityFilter", this.isProfanityFilter().toString());
        }
        if (this.getFinishOnKey() != null) {
            attrs.put("finishOnKey", this.getFinishOnKey());
        }
        if (this.getNumDigits() != null) {
            attrs.put("numDigits", this.getNumDigits().toString());
        }
        if (this.getPartialResultCallback() != null) {
            attrs.put("partialResultCallback", this.getPartialResultCallback().toString());
        }
        if (this.getPartialResultCallbackMethod() != null) {
            attrs.put("partialResultCallbackMethod", this.getPartialResultCallbackMethod().toString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }
        if (this.getHints() != null) {
            attrs.put("hints", this.getHints());
        }
        if (this.isBargeIn() != null) {
            attrs.put("bargeIn", this.isBargeIn().toString());
        }

        return attrs;
    }

    /**
     * Input type Twilio should accept
     * 
     * @return Input type Twilio should accept
     */
    public Gather.Input getInput() {
        return input;
    }

    /**
     * Action URL
     * 
     * @return Action URL
     */
    public URI getAction() {
        return action;
    }

    /**
     * Action URL method
     * 
     * @return Action URL method
     */
    public HttpMethod getMethod() {
        return method;
    }

    /**
     * Time to wait to gather input
     * 
     * @return Time to wait to gather input
     */
    public Integer getTimeout() {
        return timeout;
    }

    /**
     * Time to wait to gather speech input and it should be either auto or a
     * positive integer.
     * 
     * @return Time to wait to gather speech input and it should be either auto or
     *         a positive integer.
     */
    public String getSpeechTimeout() {
        return speechTimeout;
    }

    /**
     * Max allowed time for speech input
     * 
     * @return Max allowed time for speech input
     */
    public Integer getMaxSpeechTime() {
        return maxSpeechTime;
    }

    /**
     * Profanity Filter on speech
     * 
     * @return Profanity Filter on speech
     */
    public Boolean isProfanityFilter() {
        return profanityFilter;
    }

    /**
     * Finish gather on key
     * 
     * @return Finish gather on key
     */
    public String getFinishOnKey() {
        return finishOnKey;
    }

    /**
     * Number of digits to collect
     * 
     * @return Number of digits to collect
     */
    public Integer getNumDigits() {
        return numDigits;
    }

    /**
     * Partial result callback URL
     * 
     * @return Partial result callback URL
     */
    public URI getPartialResultCallback() {
        return partialResultCallback;
    }

    /**
     * Partial result callback URL method
     * 
     * @return Partial result callback URL method
     */
    public HttpMethod getPartialResultCallbackMethod() {
        return partialResultCallbackMethod;
    }

    /**
     * Language to use
     * 
     * @return Language to use
     */
    public Gather.Language getLanguage() {
        return language;
    }

    /**
     * Speech recognition hints
     * 
     * @return Speech recognition hints
     */
    public String getHints() {
        return hints;
    }

    /**
     * Stop playing media upon speech
     * 
     * @return Stop playing media upon speech
     */
    public Boolean isBargeIn() {
        return bargeIn;
    }

    /**
     * Create a new {@code <Gather>} element
     */
    public static class Builder {
        private Gather.Input input;
        private URI action;
        private HttpMethod method;
        private Integer timeout;
        private String speechTimeout;
        private Integer maxSpeechTime;
        private Boolean profanityFilter;
        private String finishOnKey;
        private Integer numDigits;
        private URI partialResultCallback;
        private HttpMethod partialResultCallbackMethod;
        private Gather.Language language;
        private String hints;
        private Boolean bargeIn;
        private Map<String, String> options = new HashMap<>();
        private List<TwiML> children = new ArrayList<>();

        /**
         * Input type Twilio should accept
         */
        public Builder input(Gather.Input input) {
            this.input = input;
            return this;
        }

        /**
         * Action URL
         */
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        /**
         * Action URL
         */
        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        /**
         * Action URL method
         */
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Time to wait to gather input
         */
        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Time to wait to gather speech input and it should be either auto or a
         * positive integer.
         */
        public Builder speechTimeout(String speechTimeout) {
            this.speechTimeout = speechTimeout;
            return this;
        }

        /**
         * Max allowed time for speech input
         */
        public Builder maxSpeechTime(Integer maxSpeechTime) {
            this.maxSpeechTime = maxSpeechTime;
            return this;
        }

        /**
         * Profanity Filter on speech
         */
        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        /**
         * Finish gather on key
         */
        public Builder finishOnKey(String finishOnKey) {
            this.finishOnKey = finishOnKey;
            return this;
        }

        /**
         * Number of digits to collect
         */
        public Builder numDigits(Integer numDigits) {
            this.numDigits = numDigits;
            return this;
        }

        /**
         * Partial result callback URL
         */
        public Builder partialResultCallback(URI partialResultCallback) {
            this.partialResultCallback = partialResultCallback;
            return this;
        }

        /**
         * Partial result callback URL
         */
        public Builder partialResultCallback(String partialResultCallback) {
            this.partialResultCallback = Promoter.uriFromString(partialResultCallback);
            return this;
        }

        /**
         * Partial result callback URL method
         */
        public Builder partialResultCallbackMethod(HttpMethod partialResultCallbackMethod) {
            this.partialResultCallbackMethod = partialResultCallbackMethod;
            return this;
        }

        /**
         * Language to use
         */
        public Builder language(Gather.Language language) {
            this.language = language;
            return this;
        }

        /**
         * Speech recognition hints
         */
        public Builder hints(String hints) {
            this.hints = hints;
            return this;
        }

        /**
         * Stop playing media upon speech
         */
        public Builder bargeIn(Boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        /**
         * Add a child {@code <Say>} element
         */
        public Builder say(Say say) {
            this.children.add(say);
            return this;
        }

        /**
         * Add a child {@code <Pause>} element
         */
        public Builder pause(Pause pause) {
            this.children.add(pause);
            return this;
        }

        /**
         * Add a child {@code <Play>} element
         */
        public Builder play(Play play) {
            this.children.add(play);
            return this;
        }

        /**
         * Set additional attributes on this TwiML element that will appear in generated
         * XML.
         */
        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        /**
         * Create and return resulting {@code <Gather>} element
         */
        public Gather build() {
            return new Gather(this);
        }
    }
}