/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Record>}
 */
public class Record extends TwiML {
    public enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final URI action;
    private final HttpMethod method;
    private final Integer timeout;
    private final String finishOnKey;
    private final Integer maxLength;
    private final Boolean playBeep;
    private final Record.Trim trim;
    private final URI recordingStatusCallback;
    private final HttpMethod recordingStatusCallbackMethod;
    private final Boolean transcribe;
    private final URI transcribeCallback;

    /**
     * For XML Serialization/Deserialization
     */
    private Record() {
        this(new Builder());
    }

    /**
     * Create a new {@code <Record>} element
     */
    private Record(Builder b) {
        super("Record", Collections.<TwiML>emptyList(), b.options);
        this.action = b.action;
        this.method = b.method;
        this.timeout = b.timeout;
        this.finishOnKey = b.finishOnKey;
        this.maxLength = b.maxLength;
        this.playBeep = b.playBeep;
        this.trim = b.trim;
        this.recordingStatusCallback = b.recordingStatusCallback;
        this.recordingStatusCallbackMethod = b.recordingStatusCallbackMethod;
        this.transcribe = b.transcribe;
        this.transcribeCallback = b.transcribeCallback;
    }

    /**
     * Attributes to set on the generated XML element
     * 
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        if (this.getFinishOnKey() != null) {
            attrs.put("finishOnKey", this.getFinishOnKey());
        }
        if (this.getMaxLength() != null) {
            attrs.put("maxLength", this.getMaxLength().toString());
        }
        if (this.isPlayBeep() != null) {
            attrs.put("playBeep", this.isPlayBeep().toString());
        }
        if (this.getTrim() != null) {
            attrs.put("trim", this.getTrim().toString());
        }
        if (this.getRecordingStatusCallback() != null) {
            attrs.put("recordingStatusCallback", this.getRecordingStatusCallback().toString());
        }
        if (this.getRecordingStatusCallbackMethod() != null) {
            attrs.put("recordingStatusCallbackMethod", this.getRecordingStatusCallbackMethod().toString());
        }
        if (this.isTranscribe() != null) {
            attrs.put("transcribe", this.isTranscribe().toString());
        }
        if (this.getTranscribeCallback() != null) {
            attrs.put("transcribeCallback", this.getTranscribeCallback().toString());
        }

        return attrs;
    }

    /**
     * Action URL
     * 
     * @return Action URL
     */
    public URI getAction() {
        return action;
    }

    /**
     * Action URL method
     * 
     * @return Action URL method
     */
    public HttpMethod getMethod() {
        return method;
    }

    /**
     * Timeout to begin recording
     * 
     * @return Timeout to begin recording
     */
    public Integer getTimeout() {
        return timeout;
    }

    /**
     * Finish recording on key
     * 
     * @return Finish recording on key
     */
    public String getFinishOnKey() {
        return finishOnKey;
    }

    /**
     * Max time to record in seconds
     * 
     * @return Max time to record in seconds
     */
    public Integer getMaxLength() {
        return maxLength;
    }

    /**
     * Play beep
     * 
     * @return Play beep
     */
    public Boolean isPlayBeep() {
        return playBeep;
    }

    /**
     * Trim the recording
     * 
     * @return Trim the recording
     */
    public Record.Trim getTrim() {
        return trim;
    }

    /**
     * Status callback URL
     * 
     * @return Status callback URL
     */
    public URI getRecordingStatusCallback() {
        return recordingStatusCallback;
    }

    /**
     * Status callback URL method
     * 
     * @return Status callback URL method
     */
    public HttpMethod getRecordingStatusCallbackMethod() {
        return recordingStatusCallbackMethod;
    }

    /**
     * Transcribe the recording
     * 
     * @return Transcribe the recording
     */
    public Boolean isTranscribe() {
        return transcribe;
    }

    /**
     * Transcribe callback URL
     * 
     * @return Transcribe callback URL
     */
    public URI getTranscribeCallback() {
        return transcribeCallback;
    }

    /**
     * Create a new {@code <Record>} element
     */
    public static class Builder {
        private URI action;
        private HttpMethod method;
        private Integer timeout;
        private String finishOnKey;
        private Integer maxLength;
        private Boolean playBeep;
        private Record.Trim trim;
        private URI recordingStatusCallback;
        private HttpMethod recordingStatusCallbackMethod;
        private Boolean transcribe;
        private URI transcribeCallback;
        private Map<String, String> options = new HashMap<>();

        /**
         * Action URL
         */
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        /**
         * Action URL
         */
        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        /**
         * Action URL method
         */
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Timeout to begin recording
         */
        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Finish recording on key
         */
        public Builder finishOnKey(String finishOnKey) {
            this.finishOnKey = finishOnKey;
            return this;
        }

        /**
         * Max time to record in seconds
         */
        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        /**
         * Play beep
         */
        public Builder playBeep(Boolean playBeep) {
            this.playBeep = playBeep;
            return this;
        }

        /**
         * Trim the recording
         */
        public Builder trim(Record.Trim trim) {
            this.trim = trim;
            return this;
        }

        /**
         * Status callback URL
         */
        public Builder recordingStatusCallback(URI recordingStatusCallback) {
            this.recordingStatusCallback = recordingStatusCallback;
            return this;
        }

        /**
         * Status callback URL
         */
        public Builder recordingStatusCallback(String recordingStatusCallback) {
            this.recordingStatusCallback = Promoter.uriFromString(recordingStatusCallback);
            return this;
        }

        /**
         * Status callback URL method
         */
        public Builder recordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
            this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
            return this;
        }

        /**
         * Transcribe the recording
         */
        public Builder transcribe(Boolean transcribe) {
            this.transcribe = transcribe;
            return this;
        }

        /**
         * Transcribe callback URL
         */
        public Builder transcribeCallback(URI transcribeCallback) {
            this.transcribeCallback = transcribeCallback;
            return this;
        }

        /**
         * Transcribe callback URL
         */
        public Builder transcribeCallback(String transcribeCallback) {
            this.transcribeCallback = Promoter.uriFromString(transcribeCallback);
            return this;
        }

        /**
         * Set additional attributes on this TwiML element that will appear in generated
         * XML.
         */
        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        /**
         * Create and return resulting {@code <Record>} element
         */
        public Record build() {
            return new Record(this);
        }
    }
}