/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.twilio.twiml.TwiML;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Say>}
 */
public class Say extends TwiML {
    public enum Voice {
        MAN("man"),
        WOMAN("woman"),
        ALICE("alice");

        private final String value;

        private Voice(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    public enum Language {
        DA_DK("da-DK"),
        DE_DE("de-DE"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_US("en-US"),
        CA_ES("ca-ES"),
        ES_ES("es-ES"),
        ES_MX("es-MX"),
        FI_FI("fi-FI"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        IT_IT("it-IT"),
        JA_JP("ja-JP"),
        KO_KR("ko-KR"),
        NB_NO("nb-NO"),
        NL_NL("nl-NL"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RU_RU("ru-RU"),
        SV_SE("sv-SE"),
        ZH_CN("zh-CN"),
        ZH_HK("zh-HK"),
        ZH_TW("zh-TW");

        private final String value;

        private Language(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }
    }

    private final Say.Voice voice;
    private final Integer loop;
    private final Say.Language language;
    private final String message;

    /**
     * For XML Serialization/Deserialization
     */
    private Say() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Say>} element
     */
    private Say(Builder b) {
        super("Say", Collections.<TwiML>emptyList(), b.options);
        this.voice = b.voice;
        this.loop = b.loop;
        this.language = b.language;
        this.message = b.message;
    }

    /**
     * The body of the TwiML element
     * 
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getMessage() == null ? null : this.getMessage();
    }

    /**
     * Attributes to set on the generated XML element
     * 
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getVoice() != null) {
            attrs.put("voice", this.getVoice().toString());
        }
        if (this.getLoop() != null) {
            attrs.put("loop", this.getLoop().toString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }

        return attrs;
    }

    /**
     * Voice to use
     * 
     * @return Voice to use
     */
    public Say.Voice getVoice() {
        return voice;
    }

    /**
     * Times to loop message
     * 
     * @return Times to loop message
     */
    public Integer getLoop() {
        return loop;
    }

    /**
     * Message langauge
     * 
     * @return Message langauge
     */
    public Say.Language getLanguage() {
        return language;
    }

    /**
     * Message to say
     * 
     * @return Message to say
     */
    public String getMessage() {
        return message;
    }

    /**
     * Create a new {@code <Say>} element
     */
    public static class Builder {
        private Say.Voice voice;
        private Integer loop;
        private Say.Language language;
        private String message;
        private Map<String, String> options = new HashMap<>();

        /**
         * Create a {@code <Say>} with message
         */
        public Builder(String message) {
            this.message = message;
        }

        /**
         * Voice to use
         */
        public Builder voice(Say.Voice voice) {
            this.voice = voice;
            return this;
        }

        /**
         * Times to loop message
         */
        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        /**
         * Message langauge
         */
        public Builder language(Say.Language language) {
            this.language = language;
            return this;
        }

        /**
         * Set additional attributes on this TwiML element that will appear in generated
         * XML.
         */
        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        /**
         * Create and return resulting {@code <Say>} element
         */
        public Say build() {
            return new Say(this);
        }
    }
}