/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.twilio.twiml.TwiML;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Sim>}
 */
public class Sim extends TwiML {
    private final String simSid;

    /**
     * For XML Serialization/Deserialization
     */
    private Sim() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Sim>} element
     */
    private Sim(Builder b) {
        super("Sim", Collections.<TwiML>emptyList(), b.options);
        this.simSid = b.simSid;
    }

    /**
     * The body of the TwiML element
     * 
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getSimSid() == null ? null : this.getSimSid();
    }

    /**
     * SIM SID
     * 
     * @return SIM SID
     */
    public String getSimSid() {
        return simSid;
    }

    /**
     * Create a new {@code <Sim>} element
     */
    public static class Builder {
        private String simSid;
        private Map<String, String> options = new HashMap<>();

        /**
         * Create a {@code <Sim>} with simSid
         */
        public Builder(String simSid) {
            this.simSid = simSid;
        }

        /**
         * Set additional attributes on this TwiML element that will appear in generated
         * XML.
         */
        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        /**
         * Create and return resulting {@code <Sim>} element
         */
        public Sim build() {
            return new Sim(this);
        }
    }
}