/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class ConferenceUpdater extends Updater<Conference> {
    private String pathAccountSid;
    private final String pathSid;
    private Conference.UpdateStatus status;
    private URI announceUrl;
    private HttpMethod announceMethod;

    /**
     * Construct a new ConferenceUpdater.
     *
     * @param pathSid The unique string that identifies this resource
     */
    public ConferenceUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * Construct a new ConferenceUpdater.
     *
     * @param pathAccountSid The SID of the Account that created the resource(s) to
     *                       update
     * @param pathSid The unique string that identifies this resource
     */
    public ConferenceUpdater(final String pathAccountSid,
                             final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    /**
     * The new status of the resource. Can be:  Can be: `init`, `in-progress`, or
     * `completed`. Specifying `completed` will end the conference and hang up all
     * participants.
     *
     * @param status The new status of the resource
     * @return this
     */
    public ConferenceUpdater setStatus(final Conference.UpdateStatus status) {
        this.status = status;
        return this;
    }

    /**
     * The URL we should call to announce something into the conference. The URL can
     * return an MP3, a WAV, or a TwiML document with `&lt;Play&gt;` or
     * `&lt;Say&gt;`..
     *
     * @param announceUrl The URL we should call to announce something into the
     *                    conference
     * @return this
     */
    public ConferenceUpdater setAnnounceUrl(final URI announceUrl) {
        this.announceUrl = announceUrl;
        return this;
    }

    /**
     * The URL we should call to announce something into the conference. The URL can
     * return an MP3, a WAV, or a TwiML document with `&lt;Play&gt;` or
     * `&lt;Say&gt;`..
     *
     * @param announceUrl The URL we should call to announce something into the
     *                    conference
     * @return this
     */
    public ConferenceUpdater setAnnounceUrl(final String announceUrl) {
        return setAnnounceUrl(Promoter.uriFromString(announceUrl));
    }

    /**
     * The HTTP method used to call `announce_url`. Can be: `GET` or `POST` and the
     * default is `POST`.
     *
     * @param announceMethod he HTTP method used to call announce_url
     * @return this
     */
    public ConferenceUpdater setAnnounceMethod(final HttpMethod announceMethod) {
        this.announceMethod = announceMethod;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Conference
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Conference update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences/" + this.pathSid + ".json"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Conference update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Conference.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (status != null) {
            request.addPostParam("Status", status.toString());
        }

        if (announceUrl != null) {
            request.addPostParam("AnnounceUrl", announceUrl.toString());
        }

        if (announceMethod != null) {
            request.addPostParam("AnnounceMethod", announceMethod.toString());
        }
    }
}