/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.availablephonenumbercountry;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class LocalReader extends Reader<Local> {
    private String pathAccountSid;
    private final String pathCountryCode;
    private Integer areaCode;
    private String contains;
    private Boolean smsEnabled;
    private Boolean mmsEnabled;
    private Boolean voiceEnabled;
    private Boolean excludeAllAddressRequired;
    private Boolean excludeLocalAddressRequired;
    private Boolean excludeForeignAddressRequired;
    private Boolean beta;
    private com.twilio.type.PhoneNumber nearNumber;
    private String nearLatLong;
    private Integer distance;
    private String inPostalCode;
    private String inRegion;
    private String inRateCenter;
    private String inLata;
    private String inLocality;
    private Boolean faxEnabled;

    /**
     * Construct a new LocalReader.
     *
     * @param pathCountryCode The ISO Country code of the country from which to
     *                        read phone numbers
     */
    public LocalReader(final String pathCountryCode) {
        this.pathCountryCode = pathCountryCode;
    }

    /**
     * Construct a new LocalReader.
     *
     * @param pathAccountSid The SID of the Account requesting the
     *                       AvailablePhoneNumber resources
     * @param pathCountryCode The ISO Country code of the country from which to
     *                        read phone numbers
     */
    public LocalReader(final String pathAccountSid,
                       final String pathCountryCode) {
        this.pathAccountSid = pathAccountSid;
        this.pathCountryCode = pathCountryCode;
    }

    /**
     * The area code of the phone numbers to read. Applies to only phone numbers in
     * the US and Canada..
     *
     * @param areaCode The area code of the phone numbers to read
     * @return this
     */
    public LocalReader setAreaCode(final Integer areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    /**
     * The pattern on which to match phone numbers. Valid characters are `*`, `0-9`,
     * `a-z`, and `A-Z`. The `*` character matches any single digit. For examples,
     * see <a
     * href="https://www.twilio.com/docs/phone-numbers/api/availablephonenumberlocal-resource?code-sample=code-find-phone-numbers-by-number-pattern">Example
     * 2</a> and <a
     * href="https://www.twilio.com/docs/phone-numbers/api/availablephonenumberlocal-resource?code-sample=code-find-phone-numbers-by-character-pattern">Example
     * 3</a>. If specified, this value must have at least two characters..
     *
     * @param contains The pattern on which to match phone numbers
     * @return this
     */
    public LocalReader setContains(final String contains) {
        this.contains = contains;
        return this;
    }

    /**
     * Whether the phone numbers can receive text messages. Can be: `true` or
     * `false`..
     *
     * @param smsEnabled Whether the phone numbers can receive text messages
     * @return this
     */
    public LocalReader setSmsEnabled(final Boolean smsEnabled) {
        this.smsEnabled = smsEnabled;
        return this;
    }

    /**
     * Whether the phone numbers can receive MMS messages. Can be: `true` or
     * `false`..
     *
     * @param mmsEnabled Whether the phone numbers can receive MMS messages
     * @return this
     */
    public LocalReader setMmsEnabled(final Boolean mmsEnabled) {
        this.mmsEnabled = mmsEnabled;
        return this;
    }

    /**
     * Whether the phone numbers can receive calls. Can be: `true` or `false`..
     *
     * @param voiceEnabled Whether the phone numbers can receive calls.
     * @return this
     */
    public LocalReader setVoiceEnabled(final Boolean voiceEnabled) {
        this.voiceEnabled = voiceEnabled;
        return this;
    }

    /**
     * Whether to exclude phone numbers that require an <a
     * href="https://www.twilio.com/docs/usage/api/address">Address</a>. Can be:
     * `true` or `false` and the default is `false`..
     *
     * @param excludeAllAddressRequired Whether to exclude phone numbers that
     *                                  require an Address
     * @return this
     */
    public LocalReader setExcludeAllAddressRequired(final Boolean excludeAllAddressRequired) {
        this.excludeAllAddressRequired = excludeAllAddressRequired;
        return this;
    }

    /**
     * Whether to exclude phone numbers that require a local <a
     * href="https://www.twilio.com/docs/usage/api/address">Address</a>. Can be:
     * `true` or `false` and the default is `false`..
     *
     * @param excludeLocalAddressRequired Whether to exclude phone numbers that
     *                                    require a local address
     * @return this
     */
    public LocalReader setExcludeLocalAddressRequired(final Boolean excludeLocalAddressRequired) {
        this.excludeLocalAddressRequired = excludeLocalAddressRequired;
        return this;
    }

    /**
     * Whether to exclude phone numbers that require a foreign <a
     * href="https://www.twilio.com/docs/usage/api/address">Address</a>. Can be:
     * `true` or `false` and the default is `false`..
     *
     * @param excludeForeignAddressRequired Whether to exclude phone numbers that
     *                                      require a foreign address
     * @return this
     */
    public LocalReader setExcludeForeignAddressRequired(final Boolean excludeForeignAddressRequired) {
        this.excludeForeignAddressRequired = excludeForeignAddressRequired;
        return this;
    }

    /**
     * Whether to read phone numbers that are new to the Twilio platform. Can be:
     * `true` or `false` and the default is `true`..
     *
     * @param beta Whether to read phone numbers new to the Twilio platform
     * @return this
     */
    public LocalReader setBeta(final Boolean beta) {
        this.beta = beta;
        return this;
    }

    /**
     * Given a phone number, find a geographically close number within `distance`
     * miles. Distance defaults to 25 miles. Applies to only phone numbers in the US
     * and Canada..
     *
     * @param nearNumber Given a phone number, find a geographically close number
     *                   within distance miles. (US/Canada only)
     * @return this
     */
    public LocalReader setNearNumber(final com.twilio.type.PhoneNumber nearNumber) {
        this.nearNumber = nearNumber;
        return this;
    }

    /**
     * Given a phone number, find a geographically close number within `distance`
     * miles. Distance defaults to 25 miles. Applies to only phone numbers in the US
     * and Canada..
     *
     * @param nearNumber Given a phone number, find a geographically close number
     *                   within distance miles. (US/Canada only)
     * @return this
     */
    public LocalReader setNearNumber(final String nearNumber) {
        return setNearNumber(Promoter.phoneNumberFromString(nearNumber));
    }

    /**
     * Given a latitude/longitude pair `lat,long` find geographically close numbers
     * within `distance` miles. Applies to only phone numbers in the US and Canada..
     *
     * @param nearLatLong Given a latitude/longitude pair lat,long find
     *                    geographically close numbers within distance miles.
     *                    (US/Canada only)
     * @return this
     */
    public LocalReader setNearLatLong(final String nearLatLong) {
        this.nearLatLong = nearLatLong;
        return this;
    }

    /**
     * The search radius, in miles, for a `near_` query.  Can be up to `500` and the
     * default is `25`. Applies to only phone numbers in the US and Canada..
     *
     * @param distance The search radius, in miles, for a near_ query. (US/Canada
     *                 only)
     * @return this
     */
    public LocalReader setDistance(final Integer distance) {
        this.distance = distance;
        return this;
    }

    /**
     * Limit results to a particular postal code. Given a phone number, search
     * within the same postal code as that number. Applies to only phone numbers in
     * the US and Canada..
     *
     * @param inPostalCode Limit results to a particular postal code. (US/Canada
     *                     only)
     * @return this
     */
    public LocalReader setInPostalCode(final String inPostalCode) {
        this.inPostalCode = inPostalCode;
        return this;
    }

    /**
     * Limit results to a particular region, state, or province. Given a phone
     * number, search within the same region as that number. Applies to only phone
     * numbers in the US and Canada..
     *
     * @param inRegion Limit results to a particular region. (US/Canada only)
     * @return this
     */
    public LocalReader setInRegion(final String inRegion) {
        this.inRegion = inRegion;
        return this;
    }

    /**
     * Limit results to a specific rate center, or given a phone number search
     * within the same rate center as that number. Requires `in_lata` to be set as
     * well. Applies to only phone numbers in the US and Canada..
     *
     * @param inRateCenter Limit results to a specific rate center, or given a
     *                     phone number search within the same rate center as that
     *                     number. (US/Canada only)
     * @return this
     */
    public LocalReader setInRateCenter(final String inRateCenter) {
        this.inRateCenter = inRateCenter;
        return this;
    }

    /**
     * Limit results to a specific local access and transport area (<a
     * href="https://en.wikipedia.org/wiki/Local_access_and_transport_area">LATA</a>).
     * Given a phone number, search within the same <a
     * href="https://en.wikipedia.org/wiki/Local_access_and_transport_area">LATA</a>
     * as that number. Applies to only phone numbers in the US and Canada..
     *
     * @param inLata Limit results to a specific local access and transport area.
     *               (US/Canada only)
     * @return this
     */
    public LocalReader setInLata(final String inLata) {
        this.inLata = inLata;
        return this;
    }

    /**
     * Limit results to a particular locality or city. Given a phone number, search
     * within the same Locality as that number..
     *
     * @param inLocality Limit results to a particular locality
     * @return this
     */
    public LocalReader setInLocality(final String inLocality) {
        this.inLocality = inLocality;
        return this;
    }

    /**
     * Whether the phone numbers can receive faxes. Can be: `true` or `false`..
     *
     * @param faxEnabled Whether the phone numbers can receive faxes
     * @return this
     */
    public LocalReader setFaxEnabled(final Boolean faxEnabled) {
        this.faxEnabled = faxEnabled;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Local ResourceSet
     */
    @Override
    public ResourceSet<Local> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Local ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Local> firstPage(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.GET,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/AvailablePhoneNumbers/" + this.pathCountryCode + "/Local.json"
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     *
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return Local ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<Local> getPage(final String targetUrl, final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<Local> nextPage(final Page<Local> page,
                                final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.API.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<Local> previousPage(final Page<Local> page,
                                    final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.API.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of Local Resources for a given request.
     *
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<Local> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Local read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
           throw new ApiException(restException);
        }

        return Page.fromJson(
            "available_phone_numbers",
            response.getContent(),
            Local.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (areaCode != null) {
            request.addQueryParam("AreaCode", areaCode.toString());
        }

        if (contains != null) {
            request.addQueryParam("Contains", contains);
        }

        if (smsEnabled != null) {
            request.addQueryParam("SmsEnabled", smsEnabled.toString());
        }

        if (mmsEnabled != null) {
            request.addQueryParam("MmsEnabled", mmsEnabled.toString());
        }

        if (voiceEnabled != null) {
            request.addQueryParam("VoiceEnabled", voiceEnabled.toString());
        }

        if (excludeAllAddressRequired != null) {
            request.addQueryParam("ExcludeAllAddressRequired", excludeAllAddressRequired.toString());
        }

        if (excludeLocalAddressRequired != null) {
            request.addQueryParam("ExcludeLocalAddressRequired", excludeLocalAddressRequired.toString());
        }

        if (excludeForeignAddressRequired != null) {
            request.addQueryParam("ExcludeForeignAddressRequired", excludeForeignAddressRequired.toString());
        }

        if (beta != null) {
            request.addQueryParam("Beta", beta.toString());
        }

        if (nearNumber != null) {
            request.addQueryParam("NearNumber", nearNumber.toString());
        }

        if (nearLatLong != null) {
            request.addQueryParam("NearLatLong", nearLatLong);
        }

        if (distance != null) {
            request.addQueryParam("Distance", distance.toString());
        }

        if (inPostalCode != null) {
            request.addQueryParam("InPostalCode", inPostalCode);
        }

        if (inRegion != null) {
            request.addQueryParam("InRegion", inRegion);
        }

        if (inRateCenter != null) {
            request.addQueryParam("InRateCenter", inRateCenter);
        }

        if (inLata != null) {
            request.addQueryParam("InLata", inLata);
        }

        if (inLocality != null) {
            request.addQueryParam("InLocality", inLocality);
        }

        if (faxEnabled != null) {
            request.addQueryParam("FaxEnabled", faxEnabled.toString());
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}