/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Feedback extends Resource {
    private static final long serialVersionUID = 172313514850197L;

    public enum Issues {
        AUDIO_LATENCY("audio-latency"),
        DIGITS_NOT_CAPTURED("digits-not-captured"),
        DROPPED_CALL("dropped-call"),
        IMPERFECT_AUDIO("imperfect-audio"),
        INCORRECT_CALLER_ID("incorrect-caller-id"),
        ONE_WAY_AUDIO("one-way-audio"),
        POST_DIAL_DELAY("post-dial-delay"),
        UNSOLICITED_CALL("unsolicited-call");

        private final String value;

        private Issues(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Issues from a string.
         * @param value string value
         * @return generated Issues
         */
        @JsonCreator
        public static Issues forValue(final String value) {
            return Promoter.enumFromString(value, Issues.values());
        }
    }

    /**
     * Create a FeedbackFetcher to execute fetch.
     *
     * @param pathAccountSid The unique sid that identifies this account
     * @param pathCallSid The call sid that uniquely identifies the call
     * @return FeedbackFetcher capable of executing the fetch
     */
    public static FeedbackFetcher fetcher(final String pathAccountSid,
                                          final String pathCallSid) {
        return new FeedbackFetcher(pathAccountSid, pathCallSid);
    }

    /**
     * Create a FeedbackFetcher to execute fetch.
     *
     * @param pathCallSid The call sid that uniquely identifies the call
     * @return FeedbackFetcher capable of executing the fetch
     */
    public static FeedbackFetcher fetcher(final String pathCallSid) {
        return new FeedbackFetcher(pathCallSid);
    }

    /**
     * Create a FeedbackCreator to execute create.
     *
     * @param pathAccountSid The unique sid that identifies this account
     * @param pathCallSid The call sid that uniquely identifies the call
     * @param qualityScore The call quality expressed as an integer from 1 to 5
     * @return FeedbackCreator capable of executing the create
     */
    public static FeedbackCreator creator(final String pathAccountSid,
                                          final String pathCallSid,
                                          final Integer qualityScore) {
        return new FeedbackCreator(pathAccountSid, pathCallSid, qualityScore);
    }

    /**
     * Create a FeedbackCreator to execute create.
     *
     * @param pathCallSid The call sid that uniquely identifies the call
     * @param qualityScore The call quality expressed as an integer from 1 to 5
     * @return FeedbackCreator capable of executing the create
     */
    public static FeedbackCreator creator(final String pathCallSid,
                                          final Integer qualityScore) {
        return new FeedbackCreator(pathCallSid, qualityScore);
    }

    /**
     * Create a FeedbackUpdater to execute update.
     *
     * @param pathAccountSid The unique sid that identifies this account
     * @param pathCallSid The call sid that uniquely identifies the call
     * @return FeedbackUpdater capable of executing the update
     */
    public static FeedbackUpdater updater(final String pathAccountSid,
                                          final String pathCallSid) {
        return new FeedbackUpdater(pathAccountSid, pathCallSid);
    }

    /**
     * Create a FeedbackUpdater to execute update.
     *
     * @param pathCallSid The call sid that uniquely identifies the call
     * @return FeedbackUpdater capable of executing the update
     */
    public static FeedbackUpdater updater(final String pathCallSid) {
        return new FeedbackUpdater(pathCallSid);
    }

    /**
     * Converts a JSON String into a Feedback object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Feedback object represented by the provided JSON
     */
    public static Feedback fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Feedback.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Feedback object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Feedback object represented by the provided JSON
     */
    public static Feedback fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Feedback.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final List<Feedback.Issues> issues;
    private final Integer qualityScore;
    private final String sid;

    @JsonCreator
    private Feedback(@JsonProperty("account_sid")
                     final String accountSid,
                     @JsonProperty("date_created")
                     final String dateCreated,
                     @JsonProperty("date_updated")
                     final String dateUpdated,
                     @JsonProperty("issues")
                     final List<Feedback.Issues> issues,
                     @JsonProperty("quality_score")
                     final Integer qualityScore,
                     @JsonProperty("sid")
                     final String sid) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.issues = issues;
        this.qualityScore = qualityScore;
        this.sid = sid;
    }

    /**
     * Returns The unique sid that identifies this account.
     *
     * @return The unique sid that identifies this account
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The date this resource was created.
     *
     * @return The date this resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The date this resource was last updated.
     *
     * @return The date this resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns Issues experienced during the call.
     *
     * @return Issues experienced during the call
     */
    public final List<Feedback.Issues> getIssues() {
        return this.issues;
    }

    /**
     * Returns 1 to 5 quality score.
     *
     * @return 1 to 5 quality score
     */
    public final Integer getQualityScore() {
        return this.qualityScore;
    }

    /**
     * Returns A string that uniquely identifies this feedback resource.
     *
     * @return A string that uniquely identifies this feedback resource
     */
    public final String getSid() {
        return this.sid;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Feedback other = (Feedback) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(issues, other.issues) &&
               Objects.equals(qualityScore, other.qualityScore) &&
               Objects.equals(sid, other.sid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            dateCreated,
                            dateUpdated,
                            issues,
                            qualityScore,
                            sid);
    }
}