/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.recording.addonresult;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class PayloadFetcher extends Fetcher<Payload> {
    private String pathAccountSid;
    private final String pathReferenceSid;
    private final String pathAddOnResultSid;
    private final String pathSid;

    /**
     * Construct a new PayloadFetcher.
     *
     * @param pathReferenceSid The SID of the recording to which the AddOnResult
     *                         resource that contains the payload to fetch belongs
     * @param pathAddOnResultSid The SID of the AddOnResult to which the payload to
     *                           fetch belongs
     * @param pathSid The unique string that identifies the resource to fetch
     */
    public PayloadFetcher(final String pathReferenceSid,
                          final String pathAddOnResultSid,
                          final String pathSid) {
        this.pathReferenceSid = pathReferenceSid;
        this.pathAddOnResultSid = pathAddOnResultSid;
        this.pathSid = pathSid;
    }

    /**
     * Construct a new PayloadFetcher.
     *
     * @param pathAccountSid The SID of the Account that created the resource to
     *                       fetch
     * @param pathReferenceSid The SID of the recording to which the AddOnResult
     *                         resource that contains the payload to fetch belongs
     * @param pathAddOnResultSid The SID of the AddOnResult to which the payload to
     *                           fetch belongs
     * @param pathSid The unique string that identifies the resource to fetch
     */
    public PayloadFetcher(final String pathAccountSid,
                          final String pathReferenceSid,
                          final String pathAddOnResultSid,
                          final String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathReferenceSid = pathReferenceSid;
        this.pathAddOnResultSid = pathAddOnResultSid;
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched Payload
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Payload fetch(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.GET,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/Recordings/" + this.pathReferenceSid + "/AddOnResults/" + this.pathAddOnResultSid + "/Payloads/" + this.pathSid + ".json"
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Payload fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Payload.fromJson(response.getStream(), client.getObjectMapper());
    }
}