/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.api.v2010.account.sip;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class CredentialListUpdater extends Updater<CredentialList> {
    private String pathAccountSid;
    private final String pathSid;
    private final String friendlyName;

    /**
     * Construct a new CredentialListUpdater.
     *
     * @param pathSid Update by unique credential list Sid
     * @param friendlyName Human readable descriptive text
     */
    public CredentialListUpdater(final String pathSid,
                                 final String friendlyName) {
        this.pathSid = pathSid;
        this.friendlyName = friendlyName;
    }

    /**
     * Construct a new CredentialListUpdater.
     *
     * @param pathAccountSid The unique id of the Account that is responsible for
     *                       this resource.
     * @param pathSid Update by unique credential list Sid
     * @param friendlyName Human readable descriptive text
     */
    public CredentialListUpdater(final String pathAccountSid,
                                 final String pathSid,
                                 final String friendlyName) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
        this.friendlyName = friendlyName;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated CredentialList
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public CredentialList update(final TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(
            HttpMethod.POST,
            Domains.API.toString(),
            "/2010-04-01/Accounts/" + this.pathAccountSid + "/SIP/CredentialLists/" + this.pathSid + ".json"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("CredentialList update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return CredentialList.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }
    }
}