/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class QueryCreator extends Creator<Query> {
    private final String pathAssistantSid;
    private final String language;
    private final String query;
    private String tasks;
    private String modelBuild;

    /**
     * Construct a new QueryCreator.
     *
     * @param pathAssistantSid The SID of the Assistant that is the parent of the
     *                         new resource
     * @param language The ISO language-country string that specifies the language
     *                 used for the new query
     * @param query The end-user's natural language input
     */
    public QueryCreator(final String pathAssistantSid,
                        final String language,
                        final String query) {
        this.pathAssistantSid = pathAssistantSid;
        this.language = language;
        this.query = query;
    }

    /**
     * The list of tasks to limit the new query to. Tasks are expressed as a
     * comma-separated list of task `unique_name` values. For example,
     * `task-unique_name-1, task-unique_name-2`. Listing specific tasks is useful to
     * constrain the paths that a user can take..
     *
     * @param tasks The list of tasks to limit the new query to
     * @return this
     */
    public QueryCreator setTasks(final String tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * The SID or unique name of the <a
     * href="https://www.twilio.com/docs/autopilot/api/model-build">Model Build</a>
     * to be queried..
     *
     * @param modelBuild The SID or unique name of the Model Build to be queried
     * @return this
     */
    public QueryCreator setModelBuild(final String modelBuild) {
        this.modelBuild = modelBuild;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Query
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Query create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.AUTOPILOT.toString(),
            "/v1/Assistants/" + this.pathAssistantSid + "/Queries"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Query creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Query.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (language != null) {
            request.addPostParam("Language", language);
        }

        if (query != null) {
            request.addPostParam("Query", query);
        }

        if (tasks != null) {
            request.addPostParam("Tasks", tasks);
        }

        if (modelBuild != null) {
            request.addPostParam("ModelBuild", modelBuild.toString());
        }
    }
}