/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class WebhookUpdater extends Updater<Webhook> {
    private final String pathAssistantSid;
    private final String pathSid;
    private String uniqueName;
    private String events;
    private URI webhookUrl;
    private String webhookMethod;

    /**
     * Construct a new WebhookUpdater.
     *
     * @param pathAssistantSid The SID of the Assistant that is the parent of the
     *                         resource to update
     * @param pathSid The unique string that identifies the resource
     */
    public WebhookUpdater(final String pathAssistantSid,
                          final String pathSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathSid = pathSid;
    }

    /**
     * An application-defined string that uniquely identifies the new resource. It
     * can be used as an alternative to the `sid` in the URL path to address the
     * resource. This value must be unique and 64 characters or less in length..
     *
     * @param uniqueName An application-defined string that uniquely identifies the
     *                   resource
     * @return this
     */
    public WebhookUpdater setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    /**
     * The list of space-separated events that this Webhook will subscribe to..
     *
     * @param events The list of space-separated events that this Webhook will
     *               subscribe to.
     * @return this
     */
    public WebhookUpdater setEvents(final String events) {
        this.events = events;
        return this;
    }

    /**
     * The URL associated with this Webhook..
     *
     * @param webhookUrl The URL associated with this Webhook.
     * @return this
     */
    public WebhookUpdater setWebhookUrl(final URI webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    /**
     * The URL associated with this Webhook..
     *
     * @param webhookUrl The URL associated with this Webhook.
     * @return this
     */
    public WebhookUpdater setWebhookUrl(final String webhookUrl) {
        return setWebhookUrl(Promoter.uriFromString(webhookUrl));
    }

    /**
     * The method to be used when calling the webhook's URL..
     *
     * @param webhookMethod The method to be used when calling the webhook's URL.
     * @return this
     */
    public WebhookUpdater setWebhookMethod(final String webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Webhook
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Webhook update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.AUTOPILOT.toString(),
            "/v1/Assistants/" + this.pathAssistantSid + "/Webhooks/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }

        if (events != null) {
            request.addPostParam("Events", events);
        }

        if (webhookUrl != null) {
            request.addPostParam("WebhookUrl", webhookUrl.toString());
        }

        if (webhookMethod != null) {
            request.addPostParam("WebhookMethod", webhookMethod);
        }
    }
}