/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.bulkexports.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ExportConfiguration extends Resource {
    private static final long serialVersionUID = 121290827357040L;

    /**
     * Create a ExportConfigurationFetcher to execute fetch.
     *
     * @param pathResourceType The type of communication – Messages, Calls,
     *                         Conferences, and Participants
     * @return ExportConfigurationFetcher capable of executing the fetch
     */
    public static ExportConfigurationFetcher fetcher(final String pathResourceType) {
        return new ExportConfigurationFetcher(pathResourceType);
    }

    /**
     * Create a ExportConfigurationUpdater to execute update.
     *
     * @param pathResourceType The type of communication – Messages, Calls,
     *                         Conferences, and Participants
     * @return ExportConfigurationUpdater capable of executing the update
     */
    public static ExportConfigurationUpdater updater(final String pathResourceType) {
        return new ExportConfigurationUpdater(pathResourceType);
    }

    /**
     * Converts a JSON String into a ExportConfiguration object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ExportConfiguration object represented by the provided JSON
     */
    public static ExportConfiguration fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ExportConfiguration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ExportConfiguration object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ExportConfiguration object represented by the provided JSON
     */
    public static ExportConfiguration fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ExportConfiguration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final Boolean enabled;
    private final URI webhookUrl;
    private final String webhookMethod;
    private final String resourceType;
    private final URI url;

    @JsonCreator
    private ExportConfiguration(@JsonProperty("enabled")
                                final Boolean enabled,
                                @JsonProperty("webhook_url")
                                final URI webhookUrl,
                                @JsonProperty("webhook_method")
                                final String webhookMethod,
                                @JsonProperty("resource_type")
                                final String resourceType,
                                @JsonProperty("url")
                                final URI url) {
        this.enabled = enabled;
        this.webhookUrl = webhookUrl;
        this.webhookMethod = webhookMethod;
        this.resourceType = resourceType;
        this.url = url;
    }

    /**
     * Returns Whether files are automatically generated.
     *
     * @return Whether files are automatically generated
     */
    public final Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * Returns URL targeted at export.
     *
     * @return URL targeted at export
     */
    public final URI getWebhookUrl() {
        return this.webhookUrl;
    }

    /**
     * Returns Whether to GET or POST to the webhook url.
     *
     * @return Whether to GET or POST to the webhook url
     */
    public final String getWebhookMethod() {
        return this.webhookMethod;
    }

    /**
     * Returns The type of communication – Messages, Calls, Conferences, and
     * Participants.
     *
     * @return The type of communication – Messages, Calls, Conferences, and
     *         Participants
     */
    public final String getResourceType() {
        return this.resourceType;
    }

    /**
     * Returns The URL of this resource..
     *
     * @return The URL of this resource.
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ExportConfiguration other = (ExportConfiguration) o;

        return Objects.equals(enabled, other.enabled) &&
               Objects.equals(webhookUrl, other.webhookUrl) &&
               Objects.equals(webhookMethod, other.webhookMethod) &&
               Objects.equals(resourceType, other.resourceType) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(enabled,
                            webhookUrl,
                            webhookMethod,
                            resourceType,
                            url);
    }
}