/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.bulkexports.v1.export;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class JobFetcher extends Fetcher<Job> {
    private final String pathJobSid;

    /**
     * Construct a new JobFetcher.
     *
     * @param pathJobSid The unique string that that we created to identify the
     *                   Bulk Export job
     */
    public JobFetcher(final String pathJobSid) {
        this.pathJobSid = pathJobSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched Job
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Job fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.BULKEXPORTS.toString(),
            "/v1/Exports/Jobs/" + this.pathJobSid + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Job fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Job.fromJson(response.getStream(), client.getObjectMapper());
    }
}