/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Configuration extends Resource {
    private static final long serialVersionUID = 46775139156552L;

    /**
     * Create a ConfigurationFetcher to execute fetch.
     *
     * @return ConfigurationFetcher capable of executing the fetch
     */
    public static ConfigurationFetcher fetcher() {
        return new ConfigurationFetcher();
    }

    /**
     * Create a ConfigurationUpdater to execute update.
     *
     * @return ConfigurationUpdater capable of executing the update
     */
    public static ConfigurationUpdater updater() {
        return new ConfigurationUpdater();
    }

    /**
     * Converts a JSON String into a Configuration object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Configuration object represented by the provided JSON
     */
    public static Configuration fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Configuration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Configuration object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Configuration object represented by the provided JSON
     */
    public static Configuration fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Configuration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String defaultChatServiceSid;
    private final String defaultMessagingServiceSid;
    private final String defaultInactiveTimer;
    private final String defaultClosedTimer;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Configuration(@JsonProperty("account_sid")
                          final String accountSid,
                          @JsonProperty("default_chat_service_sid")
                          final String defaultChatServiceSid,
                          @JsonProperty("default_messaging_service_sid")
                          final String defaultMessagingServiceSid,
                          @JsonProperty("default_inactive_timer")
                          final String defaultInactiveTimer,
                          @JsonProperty("default_closed_timer")
                          final String defaultClosedTimer,
                          @JsonProperty("url")
                          final URI url,
                          @JsonProperty("links")
                          final Map<String, String> links) {
        this.accountSid = accountSid;
        this.defaultChatServiceSid = defaultChatServiceSid;
        this.defaultMessagingServiceSid = defaultMessagingServiceSid;
        this.defaultInactiveTimer = defaultInactiveTimer;
        this.defaultClosedTimer = defaultClosedTimer;
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The SID of the Account responsible for this configuration..
     *
     * @return The SID of the Account responsible for this configuration.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the default Conversation Service that every new
     * conversation is associated with..
     *
     * @return The SID of the default Conversation Service that every new
     *         conversation is associated with.
     */
    public final String getDefaultChatServiceSid() {
        return this.defaultChatServiceSid;
    }

    /**
     * Returns The SID of the default Messaging Service that every new conversation
     * is associated with..
     *
     * @return The SID of the default Messaging Service that every new conversation
     *         is associated with.
     */
    public final String getDefaultMessagingServiceSid() {
        return this.defaultMessagingServiceSid;
    }

    /**
     * Returns Default ISO8601 duration when conversation will be switched to
     * `inactive` state..
     *
     * @return Default ISO8601 duration when conversation will be switched to
     *         `inactive` state.
     */
    public final String getDefaultInactiveTimer() {
        return this.defaultInactiveTimer;
    }

    /**
     * Returns Default ISO8601 duration when conversation will be switched to
     * `closed` state..
     *
     * @return Default ISO8601 duration when conversation will be switched to
     *         `closed` state.
     */
    public final String getDefaultClosedTimer() {
        return this.defaultClosedTimer;
    }

    /**
     * Returns An absolute URL for this global configuration..
     *
     * @return An absolute URL for this global configuration.
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns Absolute URLs to access the webhook and default service
     * configurations..
     *
     * @return Absolute URLs to access the webhook and default service
     *         configurations.
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Configuration other = (Configuration) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(defaultChatServiceSid, other.defaultChatServiceSid) &&
               Objects.equals(defaultMessagingServiceSid, other.defaultMessagingServiceSid) &&
               Objects.equals(defaultInactiveTimer, other.defaultInactiveTimer) &&
               Objects.equals(defaultClosedTimer, other.defaultClosedTimer) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            defaultChatServiceSid,
                            defaultMessagingServiceSid,
                            defaultInactiveTimer,
                            defaultClosedTimer,
                            url,
                            links);
    }
}