/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ParticipantConversation extends Resource {
    private static final long serialVersionUID = 31437574372222L;

    public enum State {
        INACTIVE("inactive"),
        ACTIVE("active"),
        CLOSED("closed");

        private final String value;

        private State(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a State from a string.
         * @param value string value
         * @return generated State
         */
        @JsonCreator
        public static State forValue(final String value) {
            return Promoter.enumFromString(value, State.values());
        }
    }

    /**
     * Create a ParticipantConversationReader to execute read.
     *
     * @param pathChatServiceSid The SID of the Conversation Service that the
     *                           resource is associated with.
     * @return ParticipantConversationReader capable of executing the read
     */
    public static ParticipantConversationReader reader(final String pathChatServiceSid) {
        return new ParticipantConversationReader(pathChatServiceSid);
    }

    /**
     * Converts a JSON String into a ParticipantConversation object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ParticipantConversation object represented by the provided JSON
     */
    public static ParticipantConversation fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ParticipantConversation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ParticipantConversation object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ParticipantConversation object represented by the provided JSON
     */
    public static ParticipantConversation fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ParticipantConversation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String chatServiceSid;
    private final String participantSid;
    private final String participantUserSid;
    private final String participantIdentity;
    private final Map<String, Object> participantMessagingBinding;
    private final String conversationSid;
    private final String conversationUniqueName;
    private final String conversationFriendlyName;
    private final String conversationAttributes;
    private final ZonedDateTime conversationDateCreated;
    private final ZonedDateTime conversationDateUpdated;
    private final String conversationCreatedBy;
    private final ParticipantConversation.State conversationState;
    private final Map<String, Object> conversationTimers;
    private final Map<String, String> links;

    @JsonCreator
    private ParticipantConversation(@JsonProperty("account_sid")
                                    final String accountSid,
                                    @JsonProperty("chat_service_sid")
                                    final String chatServiceSid,
                                    @JsonProperty("participant_sid")
                                    final String participantSid,
                                    @JsonProperty("participant_user_sid")
                                    final String participantUserSid,
                                    @JsonProperty("participant_identity")
                                    final String participantIdentity,
                                    @JsonProperty("participant_messaging_binding")
                                    final Map<String, Object> participantMessagingBinding,
                                    @JsonProperty("conversation_sid")
                                    final String conversationSid,
                                    @JsonProperty("conversation_unique_name")
                                    final String conversationUniqueName,
                                    @JsonProperty("conversation_friendly_name")
                                    final String conversationFriendlyName,
                                    @JsonProperty("conversation_attributes")
                                    final String conversationAttributes,
                                    @JsonProperty("conversation_date_created")
                                    final String conversationDateCreated,
                                    @JsonProperty("conversation_date_updated")
                                    final String conversationDateUpdated,
                                    @JsonProperty("conversation_created_by")
                                    final String conversationCreatedBy,
                                    @JsonProperty("conversation_state")
                                    final ParticipantConversation.State conversationState,
                                    @JsonProperty("conversation_timers")
                                    final Map<String, Object> conversationTimers,
                                    @JsonProperty("links")
                                    final Map<String, String> links) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.participantSid = participantSid;
        this.participantUserSid = participantUserSid;
        this.participantIdentity = participantIdentity;
        this.participantMessagingBinding = participantMessagingBinding;
        this.conversationSid = conversationSid;
        this.conversationUniqueName = conversationUniqueName;
        this.conversationFriendlyName = conversationFriendlyName;
        this.conversationAttributes = conversationAttributes;
        this.conversationDateCreated = DateConverter.iso8601DateTimeFromString(conversationDateCreated);
        this.conversationDateUpdated = DateConverter.iso8601DateTimeFromString(conversationDateUpdated);
        this.conversationCreatedBy = conversationCreatedBy;
        this.conversationState = conversationState;
        this.conversationTimers = conversationTimers;
        this.links = links;
    }

    /**
     * Returns The unique ID of the Account responsible for this conversation..
     *
     * @return The unique ID of the Account responsible for this conversation.
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The unique ID of the Conversation Service this conversation belongs
     * to..
     *
     * @return The unique ID of the Conversation Service this conversation belongs
     *         to.
     */
    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    /**
     * Returns The unique ID of the Participant..
     *
     * @return The unique ID of the Participant.
     */
    public final String getParticipantSid() {
        return this.participantSid;
    }

    /**
     * Returns The unique ID for the conversation participant as Conversation User..
     *
     * @return The unique ID for the conversation participant as Conversation User.
     */
    public final String getParticipantUserSid() {
        return this.participantUserSid;
    }

    /**
     * Returns A unique string identifier for the conversation participant as
     * Conversation User..
     *
     * @return A unique string identifier for the conversation participant as
     *         Conversation User.
     */
    public final String getParticipantIdentity() {
        return this.participantIdentity;
    }

    /**
     * Returns Information about how this participant exchanges messages with the
     * conversation..
     *
     * @return Information about how this participant exchanges messages with the
     *         conversation.
     */
    public final Map<String, Object> getParticipantMessagingBinding() {
        return this.participantMessagingBinding;
    }

    /**
     * Returns The unique ID of the Conversation this Participant belongs to..
     *
     * @return The unique ID of the Conversation this Participant belongs to.
     */
    public final String getConversationSid() {
        return this.conversationSid;
    }

    /**
     * Returns An application-defined string that uniquely identifies the
     * Conversation resource..
     *
     * @return An application-defined string that uniquely identifies the
     *         Conversation resource.
     */
    public final String getConversationUniqueName() {
        return this.conversationUniqueName;
    }

    /**
     * Returns The human-readable name of this conversation..
     *
     * @return The human-readable name of this conversation.
     */
    public final String getConversationFriendlyName() {
        return this.conversationFriendlyName;
    }

    /**
     * Returns An optional string metadata field you can use to store any data you
     * wish..
     *
     * @return An optional string metadata field you can use to store any data you
     *         wish.
     */
    public final String getConversationAttributes() {
        return this.conversationAttributes;
    }

    /**
     * Returns The date that this conversation was created..
     *
     * @return The date that this conversation was created.
     */
    public final ZonedDateTime getConversationDateCreated() {
        return this.conversationDateCreated;
    }

    /**
     * Returns The date that this conversation was last updated..
     *
     * @return The date that this conversation was last updated.
     */
    public final ZonedDateTime getConversationDateUpdated() {
        return this.conversationDateUpdated;
    }

    /**
     * Returns Creator of this conversation..
     *
     * @return Creator of this conversation.
     */
    public final String getConversationCreatedBy() {
        return this.conversationCreatedBy;
    }

    /**
     * Returns The current state of this User Conversation.
     *
     * @return The current state of this User Conversation
     */
    public final ParticipantConversation.State getConversationState() {
        return this.conversationState;
    }

    /**
     * Returns Timer date values for this conversation..
     *
     * @return Timer date values for this conversation.
     */
    public final Map<String, Object> getConversationTimers() {
        return this.conversationTimers;
    }

    /**
     * Returns Absolute URLs to access the participant and conversation of this
     * Participant Conversation..
     *
     * @return Absolute URLs to access the participant and conversation of this
     *         Participant Conversation.
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ParticipantConversation other = (ParticipantConversation) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(chatServiceSid, other.chatServiceSid) &&
               Objects.equals(participantSid, other.participantSid) &&
               Objects.equals(participantUserSid, other.participantUserSid) &&
               Objects.equals(participantIdentity, other.participantIdentity) &&
               Objects.equals(participantMessagingBinding, other.participantMessagingBinding) &&
               Objects.equals(conversationSid, other.conversationSid) &&
               Objects.equals(conversationUniqueName, other.conversationUniqueName) &&
               Objects.equals(conversationFriendlyName, other.conversationFriendlyName) &&
               Objects.equals(conversationAttributes, other.conversationAttributes) &&
               Objects.equals(conversationDateCreated, other.conversationDateCreated) &&
               Objects.equals(conversationDateUpdated, other.conversationDateUpdated) &&
               Objects.equals(conversationCreatedBy, other.conversationCreatedBy) &&
               Objects.equals(conversationState, other.conversationState) &&
               Objects.equals(conversationTimers, other.conversationTimers) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            chatServiceSid,
                            participantSid,
                            participantUserSid,
                            participantIdentity,
                            participantMessagingBinding,
                            conversationSid,
                            conversationUniqueName,
                            conversationFriendlyName,
                            conversationAttributes,
                            conversationDateCreated,
                            conversationDateUpdated,
                            conversationCreatedBy,
                            conversationState,
                            conversationTimers,
                            links);
    }
}