/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class ParticipantConversationReader extends Reader<ParticipantConversation> {
    private final String pathChatServiceSid;
    private String identity;
    private String address;

    /**
     * Construct a new ParticipantConversationReader.
     *
     * @param pathChatServiceSid The SID of the Conversation Service that the
     *                           resource is associated with.
     */
    public ParticipantConversationReader(final String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    /**
     * A unique string identifier for the conversation participant as <a
     * href="https://www.twilio.com/docs/conversations/api/user-resource">Conversation
     * User</a>. This parameter is non-null if (and only if) the participant is
     * using the Conversations SDK to communicate. Limited to 256 characters..
     *
     * @param identity A unique string identifier for the conversation participant
     *                 as Conversation User.
     * @return this
     */
    public ParticipantConversationReader setIdentity(final String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * A unique string identifier for the conversation participant who's not a
     * Conversation User. This parameter could be found in messaging_binding.address
     * field of Participant resource. It should be url-encoded..
     *
     * @param address A unique string identifier for the conversation participant
     *                who's not a Conversation User.
     * @return this
     */
    public ParticipantConversationReader setAddress(final String address) {
        this.address = address;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return ParticipantConversation ResourceSet
     */
    @Override
    public ResourceSet<ParticipantConversation> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    /**
     * Make the request to the Twilio API to perform the read.
     *
     * @param client TwilioRestClient with which to make the request
     * @return ParticipantConversation ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<ParticipantConversation> firstPage(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.CONVERSATIONS.toString(),
            "/v1/Services/" + this.pathChatServiceSid + "/ParticipantConversations"
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the target page from the Twilio API.
     *
     * @param targetUrl API-generated URL for the requested results page
     * @param client TwilioRestClient with which to make the request
     * @return ParticipantConversation ResourceSet
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Page<ParticipantConversation> getPage(final String targetUrl, final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            targetUrl
        );

        return pageForRequest(client, request);
    }

    /**
     * Retrieve the next page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Next Page
     */
    @Override
    public Page<ParticipantConversation> nextPage(final Page<ParticipantConversation> page,
                                                  final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.CONVERSATIONS.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Retrieve the previous page from the Twilio API.
     *
     * @param page current page
     * @param client TwilioRestClient with which to make the request
     * @return Previous Page
     */
    @Override
    public Page<ParticipantConversation> previousPage(final Page<ParticipantConversation> page,
                                                      final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.CONVERSATIONS.toString())
        );
        return pageForRequest(client, request);
    }

    /**
     * Generate a Page of ParticipantConversation Resources for a given request.
     *
     * @param client TwilioRestClient with which to make the request
     * @param request Request to generate a page for
     * @return Page for the Request
     */
    private Page<ParticipantConversation> pageForRequest(final TwilioRestClient client, final Request request) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("ParticipantConversation read failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
           throw new ApiException(restException);
        }

        return Page.fromJson(
            "conversations",
            response.getContent(),
            ParticipantConversation.class,
            client.getObjectMapper()
        );
    }

    /**
     * Add the requested query string arguments to the Request.
     *
     * @param request Request to add query string arguments to
     */
    private void addQueryParams(final Request request) {
        if (identity != null) {
            request.addQueryParam("Identity", identity);
        }

        if (address != null) {
            request.addQueryParam("Address", address);
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}