/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1.service.configuration;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class NotificationUpdater extends Updater<Notification> {
    private final String pathChatServiceSid;
    private Boolean logEnabled;
    private Boolean newMessageEnabled;
    private String newMessageTemplate;
    private String newMessageSound;
    private Boolean newMessageBadgeCountEnabled;
    private Boolean addedToConversationEnabled;
    private String addedToConversationTemplate;
    private String addedToConversationSound;
    private Boolean removedFromConversationEnabled;
    private String removedFromConversationTemplate;
    private String removedFromConversationSound;
    private Boolean newMessageWithMediaEnabled;
    private String newMessageWithMediaTemplate;

    /**
     * Construct a new NotificationUpdater.
     *
     * @param pathChatServiceSid The SID of the Conversation Service that the
     *                           Configuration applies to.
     */
    public NotificationUpdater(final String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    /**
     * Weather the notification logging is enabled..
     *
     * @param logEnabled Weather the notification logging is enabled.
     * @return this
     */
    public NotificationUpdater setLogEnabled(final Boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    /**
     * Whether to send a notification when a new message is added to a conversation.
     * The default is `false`..
     *
     * @param newMessageEnabled Whether to send a notification when a new message
     *                          is added to a conversation.
     * @return this
     */
    public NotificationUpdater setNewMessageEnabled(final Boolean newMessageEnabled) {
        this.newMessageEnabled = newMessageEnabled;
        return this;
    }

    /**
     * The template to use to create the notification text displayed when a new
     * message is added to a conversation and `new_message.enabled` is `true`..
     *
     * @param newMessageTemplate The template to use to create the notification
     *                           text displayed when a new message is added to a
     *                           conversation.
     * @return this
     */
    public NotificationUpdater setNewMessageTemplate(final String newMessageTemplate) {
        this.newMessageTemplate = newMessageTemplate;
        return this;
    }

    /**
     * The name of the sound to play when a new message is added to a conversation
     * and `new_message.enabled` is `true`..
     *
     * @param newMessageSound The name of the sound to play when a new message is
     *                        added to a conversation.
     * @return this
     */
    public NotificationUpdater setNewMessageSound(final String newMessageSound) {
        this.newMessageSound = newMessageSound;
        return this;
    }

    /**
     * Whether the new message badge is enabled. The default is `false`..
     *
     * @param newMessageBadgeCountEnabled Whether the new message badge is enabled.
     * @return this
     */
    public NotificationUpdater setNewMessageBadgeCountEnabled(final Boolean newMessageBadgeCountEnabled) {
        this.newMessageBadgeCountEnabled = newMessageBadgeCountEnabled;
        return this;
    }

    /**
     * Whether to send a notification when a participant is added to a conversation.
     * The default is `false`..
     *
     * @param addedToConversationEnabled Whether to send a notification when a
     *                                   participant is added to a conversation.
     * @return this
     */
    public NotificationUpdater setAddedToConversationEnabled(final Boolean addedToConversationEnabled) {
        this.addedToConversationEnabled = addedToConversationEnabled;
        return this;
    }

    /**
     * The template to use to create the notification text displayed when a
     * participant is added to a conversation and `added_to_conversation.enabled` is
     * `true`..
     *
     * @param addedToConversationTemplate The template to use to create the
     *                                    notification text displayed when a
     *                                    participant is added to a conversation.
     * @return this
     */
    public NotificationUpdater setAddedToConversationTemplate(final String addedToConversationTemplate) {
        this.addedToConversationTemplate = addedToConversationTemplate;
        return this;
    }

    /**
     * The name of the sound to play when a participant is added to a conversation
     * and `added_to_conversation.enabled` is `true`..
     *
     * @param addedToConversationSound The name of the sound to play when a
     *                                 participant is added to a conversation.
     * @return this
     */
    public NotificationUpdater setAddedToConversationSound(final String addedToConversationSound) {
        this.addedToConversationSound = addedToConversationSound;
        return this;
    }

    /**
     * Whether to send a notification to a user when they are removed from a
     * conversation. The default is `false`..
     *
     * @param removedFromConversationEnabled Whether to send a notification to a
     *                                       user when they are removed from a
     *                                       conversation.
     * @return this
     */
    public NotificationUpdater setRemovedFromConversationEnabled(final Boolean removedFromConversationEnabled) {
        this.removedFromConversationEnabled = removedFromConversationEnabled;
        return this;
    }

    /**
     * The template to use to create the notification text displayed to a user when
     * they are removed from a conversation and `removed_from_conversation.enabled`
     * is `true`..
     *
     * @param removedFromConversationTemplate The template to use to create the
     *                                        notification text displayed to a user
     *                                        when they are removed.
     * @return this
     */
    public NotificationUpdater setRemovedFromConversationTemplate(final String removedFromConversationTemplate) {
        this.removedFromConversationTemplate = removedFromConversationTemplate;
        return this;
    }

    /**
     * The name of the sound to play to a user when they are removed from a
     * conversation and `removed_from_conversation.enabled` is `true`..
     *
     * @param removedFromConversationSound The name of the sound to play to a user
     *                                     when they are removed from a
     *                                     conversation.
     * @return this
     */
    public NotificationUpdater setRemovedFromConversationSound(final String removedFromConversationSound) {
        this.removedFromConversationSound = removedFromConversationSound;
        return this;
    }

    /**
     * Whether to send a notification when a new message with media/file attachments
     * is added to a conversation. The default is `false`..
     *
     * @param newMessageWithMediaEnabled Whether to send a notification when a new
     *                                   message with media/file attachments is
     *                                   added to a conversation.
     * @return this
     */
    public NotificationUpdater setNewMessageWithMediaEnabled(final Boolean newMessageWithMediaEnabled) {
        this.newMessageWithMediaEnabled = newMessageWithMediaEnabled;
        return this;
    }

    /**
     * The template to use to create the notification text displayed when a new
     * message with media/file attachments is added to a conversation and
     * `new_message.attachments.enabled` is `true`..
     *
     * @param newMessageWithMediaTemplate The template to use to create the
     *                                    notification text displayed when a new
     *                                    message with media/file attachments is
     *                                    added to a conversation.
     * @return this
     */
    public NotificationUpdater setNewMessageWithMediaTemplate(final String newMessageWithMediaTemplate) {
        this.newMessageWithMediaTemplate = newMessageWithMediaTemplate;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Notification
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Notification update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.CONVERSATIONS.toString(),
            "/v1/Services/" + this.pathChatServiceSid + "/Configuration/Notifications"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Notification update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Notification.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (logEnabled != null) {
            request.addPostParam("LogEnabled", logEnabled.toString());
        }

        if (newMessageEnabled != null) {
            request.addPostParam("NewMessage.Enabled", newMessageEnabled.toString());
        }

        if (newMessageTemplate != null) {
            request.addPostParam("NewMessage.Template", newMessageTemplate);
        }

        if (newMessageSound != null) {
            request.addPostParam("NewMessage.Sound", newMessageSound);
        }

        if (newMessageBadgeCountEnabled != null) {
            request.addPostParam("NewMessage.BadgeCountEnabled", newMessageBadgeCountEnabled.toString());
        }

        if (addedToConversationEnabled != null) {
            request.addPostParam("AddedToConversation.Enabled", addedToConversationEnabled.toString());
        }

        if (addedToConversationTemplate != null) {
            request.addPostParam("AddedToConversation.Template", addedToConversationTemplate);
        }

        if (addedToConversationSound != null) {
            request.addPostParam("AddedToConversation.Sound", addedToConversationSound);
        }

        if (removedFromConversationEnabled != null) {
            request.addPostParam("RemovedFromConversation.Enabled", removedFromConversationEnabled.toString());
        }

        if (removedFromConversationTemplate != null) {
            request.addPostParam("RemovedFromConversation.Template", removedFromConversationTemplate);
        }

        if (removedFromConversationSound != null) {
            request.addPostParam("RemovedFromConversation.Sound", removedFromConversationSound);
        }

        if (newMessageWithMediaEnabled != null) {
            request.addPostParam("NewMessage.WithMedia.Enabled", newMessageWithMediaEnabled.toString());
        }

        if (newMessageWithMediaTemplate != null) {
            request.addPostParam("NewMessage.WithMedia.Template", newMessageWithMediaTemplate);
        }
    }
}