/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.conversations.v1.service.user;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class UserConversationFetcher extends Fetcher<UserConversation> {
    private final String pathChatServiceSid;
    private final String pathUserSid;
    private final String pathConversationSid;

    /**
     * Construct a new UserConversationFetcher.
     *
     * @param pathChatServiceSid The SID of the Conversation Service that the
     *                           resource is associated with.
     * @param pathUserSid The unique SID identifier of the User.
     * @param pathConversationSid The unique SID identifier of the Conversation.
     */
    public UserConversationFetcher(final String pathChatServiceSid,
                                   final String pathUserSid,
                                   final String pathConversationSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathUserSid = pathUserSid;
        this.pathConversationSid = pathConversationSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched UserConversation
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public UserConversation fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.CONVERSATIONS.toString(),
            "/v1/Services/" + this.pathChatServiceSid + "/Users/" + this.pathUserSid + "/Conversations/" + this.pathConversationSid + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("UserConversation fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return UserConversation.fromJson(response.getStream(), client.getObjectMapper());
    }
}