/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.events.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Sink extends Resource {
    private static final long serialVersionUID = 113592032469931L;

    public enum Status {
        INITIALIZED("initialized"),
        VALIDATING("validating"),
        ACTIVE("active"),
        FAILED("failed");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum SinkType {
        KINESIS("kinesis"),
        WEBHOOK("webhook"),
        SEGMENT("segment");

        private final String value;

        private SinkType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a SinkType from a string.
         * @param value string value
         * @return generated SinkType
         */
        @JsonCreator
        public static SinkType forValue(final String value) {
            return Promoter.enumFromString(value, SinkType.values());
        }
    }

    /**
     * Create a SinkFetcher to execute fetch.
     *
     * @param pathSid A string that uniquely identifies this Sink.
     * @return SinkFetcher capable of executing the fetch
     */
    public static SinkFetcher fetcher(final String pathSid) {
        return new SinkFetcher(pathSid);
    }

    /**
     * Create a SinkCreator to execute create.
     *
     * @param description Sink Description.
     * @param sinkConfiguration JSON Sink configuration.
     * @param sinkType Sink type.
     * @return SinkCreator capable of executing the create
     */
    public static SinkCreator creator(final String description,
                                      final Map<String, Object> sinkConfiguration,
                                      final Sink.SinkType sinkType) {
        return new SinkCreator(description, sinkConfiguration, sinkType);
    }

    /**
     * Create a SinkDeleter to execute delete.
     *
     * @param pathSid A string that uniquely identifies this Sink.
     * @return SinkDeleter capable of executing the delete
     */
    public static SinkDeleter deleter(final String pathSid) {
        return new SinkDeleter(pathSid);
    }

    /**
     * Create a SinkReader to execute read.
     *
     * @return SinkReader capable of executing the read
     */
    public static SinkReader reader() {
        return new SinkReader();
    }

    /**
     * Create a SinkUpdater to execute update.
     *
     * @param pathSid A string that uniquely identifies this Sink.
     * @param description Sink Description
     * @return SinkUpdater capable of executing the update
     */
    public static SinkUpdater updater(final String pathSid,
                                      final String description) {
        return new SinkUpdater(pathSid, description);
    }

    /**
     * Converts a JSON String into a Sink object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Sink object represented by the provided JSON
     */
    public static Sink fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Sink.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Sink object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Sink object represented by the provided JSON
     */
    public static Sink fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Sink.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String description;
    private final String sid;
    private final Map<String, Object> sinkConfiguration;
    private final Sink.SinkType sinkType;
    private final Sink.Status status;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Sink(@JsonProperty("date_created")
                 final String dateCreated,
                 @JsonProperty("date_updated")
                 final String dateUpdated,
                 @JsonProperty("description")
                 final String description,
                 @JsonProperty("sid")
                 final String sid,
                 @JsonProperty("sink_configuration")
                 final Map<String, Object> sinkConfiguration,
                 @JsonProperty("sink_type")
                 final Sink.SinkType sinkType,
                 @JsonProperty("status")
                 final Sink.Status status,
                 @JsonProperty("url")
                 final URI url,
                 @JsonProperty("links")
                 final Map<String, String> links) {
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.description = description;
        this.sid = sid;
        this.sinkConfiguration = sinkConfiguration;
        this.sinkType = sinkType;
        this.status = status;
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The date this Sink was created.
     *
     * @return The date this Sink was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The date this Sink was updated.
     *
     * @return The date this Sink was updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns Sink Description.
     *
     * @return Sink Description
     */
    public final String getDescription() {
        return this.description;
    }

    /**
     * Returns A string that uniquely identifies this Sink..
     *
     * @return A string that uniquely identifies this Sink.
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns JSON Sink configuration..
     *
     * @return JSON Sink configuration.
     */
    public final Map<String, Object> getSinkConfiguration() {
        return this.sinkConfiguration;
    }

    /**
     * Returns Sink type..
     *
     * @return Sink type.
     */
    public final Sink.SinkType getSinkType() {
        return this.sinkType;
    }

    /**
     * Returns The Status of this Sink.
     *
     * @return The Status of this Sink
     */
    public final Sink.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The URL of this resource..
     *
     * @return The URL of this resource.
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns Nested resource URLs..
     *
     * @return Nested resource URLs.
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Sink other = (Sink) o;

        return Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(description, other.description) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(sinkConfiguration, other.sinkConfiguration) &&
               Objects.equals(sinkType, other.sinkType) &&
               Objects.equals(status, other.status) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(dateCreated,
                            dateUpdated,
                            description,
                            sid,
                            sinkConfiguration,
                            sinkType,
                            status,
                            url,
                            links);
    }
}