/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.events.v1.schema;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SchemaVersionFetcher extends Fetcher<SchemaVersion> {
    private final String pathId;
    private final Integer pathSchemaVersion;

    /**
     * Construct a new SchemaVersionFetcher.
     *
     * @param pathId The unique identifier of the schema.
     * @param pathSchemaVersion The version of the schema
     */
    public SchemaVersionFetcher(final String pathId,
                                final Integer pathSchemaVersion) {
        this.pathId = pathId;
        this.pathSchemaVersion = pathSchemaVersion;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched SchemaVersion
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public SchemaVersion fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.EVENTS.toString(),
            "/v1/Schemas/" + this.pathId + "/Versions/" + this.pathSchemaVersion + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("SchemaVersion fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return SchemaVersion.fromJson(response.getStream(), client.getObjectMapper());
    }
}