/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Channel extends Resource {
    private static final long serialVersionUID = 192292992411746L;

    /**
     * Create a ChannelReader to execute read.
     *
     * @return ChannelReader capable of executing the read
     */
    public static ChannelReader reader() {
        return new ChannelReader();
    }

    /**
     * Create a ChannelFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the Flex chat channel resource to
     *                fetch
     * @return ChannelFetcher capable of executing the fetch
     */
    public static ChannelFetcher fetcher(final String pathSid) {
        return new ChannelFetcher(pathSid);
    }

    /**
     * Create a ChannelCreator to execute create.
     *
     * @param flexFlowSid The SID of the Flex Flow
     * @param identity The identity value that identifies the new resource's chat
     *                 User
     * @param chatUserFriendlyName The chat participant's friendly name
     * @param chatFriendlyName The chat channel's friendly name
     * @return ChannelCreator capable of executing the create
     */
    public static ChannelCreator creator(final String flexFlowSid,
                                         final String identity,
                                         final String chatUserFriendlyName,
                                         final String chatFriendlyName) {
        return new ChannelCreator(flexFlowSid, identity, chatUserFriendlyName, chatFriendlyName);
    }

    /**
     * Create a ChannelDeleter to execute delete.
     *
     * @param pathSid The SID of the Flex chat channel resource to delete
     * @return ChannelDeleter capable of executing the delete
     */
    public static ChannelDeleter deleter(final String pathSid) {
        return new ChannelDeleter(pathSid);
    }

    /**
     * Converts a JSON String into a Channel object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Channel object represented by the provided JSON
     */
    public static Channel fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Channel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Channel object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Channel object represented by the provided JSON
     */
    public static Channel fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Channel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String flexFlowSid;
    private final String sid;
    private final String userSid;
    private final String taskSid;
    private final URI url;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    @JsonCreator
    private Channel(@JsonProperty("account_sid")
                    final String accountSid,
                    @JsonProperty("flex_flow_sid")
                    final String flexFlowSid,
                    @JsonProperty("sid")
                    final String sid,
                    @JsonProperty("user_sid")
                    final String userSid,
                    @JsonProperty("task_sid")
                    final String taskSid,
                    @JsonProperty("url")
                    final URI url,
                    @JsonProperty("date_created")
                    final String dateCreated,
                    @JsonProperty("date_updated")
                    final String dateUpdated) {
        this.accountSid = accountSid;
        this.flexFlowSid = flexFlowSid;
        this.sid = sid;
        this.userSid = userSid;
        this.taskSid = taskSid;
        this.url = url;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    /**
     * Returns The SID of the Account that created the resource and owns this
     * Workflow.
     *
     * @return The SID of the Account that created the resource and owns this
     *         Workflow
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The SID of the Flex Flow.
     *
     * @return The SID of the Flex Flow
     */
    public final String getFlexFlowSid() {
        return this.flexFlowSid;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The SID of the chat user.
     *
     * @return The SID of the chat user
     */
    public final String getUserSid() {
        return this.userSid;
    }

    /**
     * Returns The SID of the TaskRouter Task.
     *
     * @return The SID of the TaskRouter Task
     */
    public final String getTaskSid() {
        return this.taskSid;
    }

    /**
     * Returns The absolute URL of the Flex chat channel resource.
     *
     * @return The absolute URL of the Flex chat channel resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the Flex chat channel was
     * created.
     *
     * @return The ISO 8601 date and time in GMT when the Flex chat channel was
     *         created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the Flex chat channel was last
     * updated.
     *
     * @return The ISO 8601 date and time in GMT when the Flex chat channel was
     *         last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Channel other = (Channel) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(flexFlowSid, other.flexFlowSid) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(userSid, other.userSid) &&
               Objects.equals(taskSid, other.taskSid) &&
               Objects.equals(url, other.url) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            flexFlowSid,
                            sid,
                            userSid,
                            taskSid,
                            url,
                            dateCreated,
                            dateUpdated);
    }
}