/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.Map;

public class InteractionCreator extends Creator<Interaction> {
    private final Map<String, Object> channel;
    private final Map<String, Object> routing;

    /**
     * Construct a new InteractionCreator.
     *
     * @param channel The Interaction's channel
     * @param routing The Interaction's routing logic
     */
    public InteractionCreator(final Map<String, Object> channel,
                              final Map<String, Object> routing) {
        this.channel = channel;
        this.routing = routing;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Interaction
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Interaction create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.FLEXAPI.toString(),
            "/v1/Interactions"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Interaction creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Interaction.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (channel != null) {
            request.addPostParam("Channel", Converter.mapToJson(channel));
        }

        if (routing != null) {
            request.addPostParam("Routing", Converter.mapToJson(routing));
        }
    }
}