/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1.interaction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class InteractionChannel extends Resource {
    private static final long serialVersionUID = 78467581118874L;

    public enum Status {
        CLOSE("close"),
        CLOSED("closed"),
        WRAPUP("wrapup");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum Type {
        VOICE("voice"),
        SMS("sms"),
        EMAIL("email"),
        WEB("web"),
        WHATSAPP("whatsapp"),
        CHAT("chat");

        private final String value;

        private Type(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Type from a string.
         * @param value string value
         * @return generated Type
         */
        @JsonCreator
        public static Type forValue(final String value) {
            return Promoter.enumFromString(value, Type.values());
        }
    }

    /**
     * Create a InteractionChannelFetcher to execute fetch.
     *
     * @param pathInteractionSid The Interaction Sid for this channel.
     * @param pathSid The Channel Sid for this Participant.
     * @return InteractionChannelFetcher capable of executing the fetch
     */
    public static InteractionChannelFetcher fetcher(final String pathInteractionSid,
                                                    final String pathSid) {
        return new InteractionChannelFetcher(pathInteractionSid, pathSid);
    }

    /**
     * Create a InteractionChannelReader to execute read.
     *
     * @param pathInteractionSid The Interaction Sid for this channel.
     * @return InteractionChannelReader capable of executing the read
     */
    public static InteractionChannelReader reader(final String pathInteractionSid) {
        return new InteractionChannelReader(pathInteractionSid);
    }

    /**
     * Create a InteractionChannelUpdater to execute update.
     *
     * @param pathInteractionSid The Interaction Sid for this channel.
     * @param pathSid The unique string that identifies the resource
     * @param status The Interaction Channels's status
     * @return InteractionChannelUpdater capable of executing the update
     */
    public static InteractionChannelUpdater updater(final String pathInteractionSid,
                                                    final String pathSid,
                                                    final InteractionChannel.Status status) {
        return new InteractionChannelUpdater(pathInteractionSid, pathSid, status);
    }

    /**
     * Converts a JSON String into a InteractionChannel object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return InteractionChannel object represented by the provided JSON
     */
    public static InteractionChannel fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InteractionChannel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a InteractionChannel object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return InteractionChannel object represented by the provided JSON
     */
    public static InteractionChannel fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InteractionChannel.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String interactionSid;
    private final InteractionChannel.Type type;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private InteractionChannel(@JsonProperty("sid")
                               final String sid,
                               @JsonProperty("interaction_sid")
                               final String interactionSid,
                               @JsonProperty("type")
                               final InteractionChannel.Type type,
                               @JsonProperty("url")
                               final URI url,
                               @JsonProperty("links")
                               final Map<String, String> links) {
        this.sid = sid;
        this.interactionSid = interactionSid;
        this.type = type;
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The Interaction Sid for this channel..
     *
     * @return The Interaction Sid for this channel.
     */
    public final String getInteractionSid() {
        return this.interactionSid;
    }

    /**
     * Returns The Interaction Channel's type..
     *
     * @return The Interaction Channel's type.
     */
    public final InteractionChannel.Type getType() {
        return this.type;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The links.
     *
     * @return The links
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        InteractionChannel other = (InteractionChannel) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(interactionSid, other.interactionSid) &&
               Objects.equals(type, other.type) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            interactionSid,
                            type,
                            url,
                            links);
    }
}