/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.Map;

public class InteractionChannelInviteCreator extends Creator<InteractionChannelInvite> {
    private final String pathInteractionSid;
    private final String pathChannelSid;
    private final Map<String, Object> routing;

    /**
     * Construct a new InteractionChannelInviteCreator.
     *
     * @param pathInteractionSid The interaction_sid
     * @param pathChannelSid The channel_sid
     * @param routing The routing
     */
    public InteractionChannelInviteCreator(final String pathInteractionSid,
                                           final String pathChannelSid,
                                           final Map<String, Object> routing) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathChannelSid = pathChannelSid;
        this.routing = routing;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created InteractionChannelInvite
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public InteractionChannelInvite create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.FLEXAPI.toString(),
            "/v1/Interactions/" + this.pathInteractionSid + "/Channels/" + this.pathChannelSid + "/Invites"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("InteractionChannelInvite creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return InteractionChannelInvite.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (routing != null) {
            request.addPostParam("Routing", Converter.mapToJson(routing));
        }
    }
}