/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class InteractionChannelParticipant extends Resource {
    private static final long serialVersionUID = 10584956143347L;

    public enum Status {
        CLOSE("close"),
        CLOSED("closed"),
        WRAPUP("wrapup");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum Type {
        SUPERVISOR("supervisor"),
        CUSTOMER("customer"),
        EXTERNAL("external"),
        AGENT("agent"),
        UNKNOWN("unknown");

        private final String value;

        private Type(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Type from a string.
         * @param value string value
         * @return generated Type
         */
        @JsonCreator
        public static Type forValue(final String value) {
            return Promoter.enumFromString(value, Type.values());
        }
    }

    /**
     * Create a InteractionChannelParticipantCreator to execute create.
     *
     * @param pathInteractionSid The Interaction Sid for the Interaction.
     * @param pathChannelSid The Channel Sid for the Channel.
     * @param type Participant type.
     * @param mediaProperties JSON representing the Media Properties for the new
     *                        Participant.
     * @return InteractionChannelParticipantCreator capable of executing the create
     */
    public static InteractionChannelParticipantCreator creator(final String pathInteractionSid,
                                                               final String pathChannelSid,
                                                               final InteractionChannelParticipant.Type type,
                                                               final Map<String, Object> mediaProperties) {
        return new InteractionChannelParticipantCreator(pathInteractionSid, pathChannelSid, type, mediaProperties);
    }

    /**
     * Create a InteractionChannelParticipantReader to execute read.
     *
     * @param pathInteractionSid The Interaction Sid for this channel.
     * @param pathChannelSid The Channel Sid for this Participant.
     * @return InteractionChannelParticipantReader capable of executing the read
     */
    public static InteractionChannelParticipantReader reader(final String pathInteractionSid,
                                                             final String pathChannelSid) {
        return new InteractionChannelParticipantReader(pathInteractionSid, pathChannelSid);
    }

    /**
     * Create a InteractionChannelParticipantUpdater to execute update.
     *
     * @param pathInteractionSid The Interaction Sid for this channel.
     * @param pathChannelSid The Channel Sid for this Participant.
     * @param pathSid The unique string that identifies the resource
     * @param status The Participant's status.
     * @return InteractionChannelParticipantUpdater capable of executing the update
     */
    public static InteractionChannelParticipantUpdater updater(final String pathInteractionSid,
                                                               final String pathChannelSid,
                                                               final String pathSid,
                                                               final InteractionChannelParticipant.Status status) {
        return new InteractionChannelParticipantUpdater(pathInteractionSid, pathChannelSid, pathSid, status);
    }

    /**
     * Converts a JSON String into a InteractionChannelParticipant object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return InteractionChannelParticipant object represented by the provided JSON
     */
    public static InteractionChannelParticipant fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InteractionChannelParticipant.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a InteractionChannelParticipant object using
     * the provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return InteractionChannelParticipant object represented by the provided JSON
     */
    public static InteractionChannelParticipant fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, InteractionChannelParticipant.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final InteractionChannelParticipant.Type type;
    private final String interactionSid;
    private final String channelSid;
    private final URI url;

    @JsonCreator
    private InteractionChannelParticipant(@JsonProperty("sid")
                                          final String sid,
                                          @JsonProperty("type")
                                          final InteractionChannelParticipant.Type type,
                                          @JsonProperty("interaction_sid")
                                          final String interactionSid,
                                          @JsonProperty("channel_sid")
                                          final String channelSid,
                                          @JsonProperty("url")
                                          final URI url) {
        this.sid = sid;
        this.type = type;
        this.interactionSid = interactionSid;
        this.channelSid = channelSid;
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns Participant type..
     *
     * @return Participant type.
     */
    public final InteractionChannelParticipant.Type getType() {
        return this.type;
    }

    /**
     * Returns The Interaction Sid for this channel..
     *
     * @return The Interaction Sid for this channel.
     */
    public final String getInteractionSid() {
        return this.interactionSid;
    }

    /**
     * Returns The Channel Sid for this Participant..
     *
     * @return The Channel Sid for this Participant.
     */
    public final String getChannelSid() {
        return this.channelSid;
    }

    /**
     * Returns The url.
     *
     * @return The url
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        InteractionChannelParticipant other = (InteractionChannelParticipant) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(type, other.type) &&
               Objects.equals(interactionSid, other.interactionSid) &&
               Objects.equals(channelSid, other.channelSid) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            type,
                            interactionSid,
                            channelSid,
                            url);
    }
}