/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.Map;

public class InteractionChannelParticipantCreator extends Creator<InteractionChannelParticipant> {
    private final String pathInteractionSid;
    private final String pathChannelSid;
    private final InteractionChannelParticipant.Type type;
    private final Map<String, Object> mediaProperties;

    /**
     * Construct a new InteractionChannelParticipantCreator.
     *
     * @param pathInteractionSid The Interaction Sid for the Interaction.
     * @param pathChannelSid The Channel Sid for the Channel.
     * @param type Participant type.
     * @param mediaProperties JSON representing the Media Properties for the new
     *                        Participant.
     */
    public InteractionChannelParticipantCreator(final String pathInteractionSid,
                                                final String pathChannelSid,
                                                final InteractionChannelParticipant.Type type,
                                                final Map<String, Object> mediaProperties) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathChannelSid = pathChannelSid;
        this.type = type;
        this.mediaProperties = mediaProperties;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created InteractionChannelParticipant
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public InteractionChannelParticipant create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.FLEXAPI.toString(),
            "/v1/Interactions/" + this.pathInteractionSid + "/Channels/" + this.pathChannelSid + "/Participants"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("InteractionChannelParticipant creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return InteractionChannelParticipant.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (type != null) {
            request.addPostParam("Type", type.toString());
        }

        if (mediaProperties != null) {
            request.addPostParam("MediaProperties", Converter.mapToJson(mediaProperties));
        }
    }
}