/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.flexapi.v1.interaction.interactionchannel;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class InteractionChannelParticipantUpdater extends Updater<InteractionChannelParticipant> {
    private final String pathInteractionSid;
    private final String pathChannelSid;
    private final String pathSid;
    private final InteractionChannelParticipant.Status status;

    /**
     * Construct a new InteractionChannelParticipantUpdater.
     *
     * @param pathInteractionSid The Interaction Sid for this channel.
     * @param pathChannelSid The Channel Sid for this Participant.
     * @param pathSid The unique string that identifies the resource
     * @param status The Participant's status.
     */
    public InteractionChannelParticipantUpdater(final String pathInteractionSid,
                                                final String pathChannelSid,
                                                final String pathSid,
                                                final InteractionChannelParticipant.Status status) {
        this.pathInteractionSid = pathInteractionSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
        this.status = status;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated InteractionChannelParticipant
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public InteractionChannelParticipant update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.FLEXAPI.toString(),
            "/v1/Interactions/" + this.pathInteractionSid + "/Channels/" + this.pathChannelSid + "/Participants/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("InteractionChannelParticipant update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return InteractionChannelParticipant.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (status != null) {
            request.addPostParam("Status", status.toString());
        }
    }
}