/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.frontlineapi.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class UserUpdater extends Updater<User> {
    private final String pathSid;
    private String friendlyName;
    private String avatar;
    private User.StateType state;
    private Boolean isAvailable;

    /**
     * Construct a new UserUpdater.
     *
     * @param pathSid The SID of the User resource to update
     */
    public UserUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * The string that you assigned to describe the User..
     *
     * @param friendlyName The string that you assigned to describe the User
     * @return this
     */
    public UserUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The avatar URL which will be shown in Frontline application..
     *
     * @param avatar The avatar URL which will be shown in Frontline application
     * @return this
     */
    public UserUpdater setAvatar(final String avatar) {
        this.avatar = avatar;
        return this;
    }

    /**
     * Current state of this user. Can be either `active` or `deactivated`..
     *
     * @param state Current state of this user
     * @return this
     */
    public UserUpdater setState(final User.StateType state) {
        this.state = state;
        return this;
    }

    /**
     * Whether the User is available for new conversations. Set to `false` to
     * prevent User from receiving new inbound conversations if you are using <a
     * href="https://www.twilio.com/docs/frontline/handle-incoming-conversations#3-pool-routing">Pool
     * Routing</a>..
     *
     * @param isAvailable Whether the User is available for new conversations
     * @return this
     */
    public UserUpdater setIsAvailable(final Boolean isAvailable) {
        this.isAvailable = isAvailable;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated User
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public User update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.FRONTLINEAPI.toString(),
            "/v1/Users/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("User update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return User.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (avatar != null) {
            request.addPostParam("Avatar", avatar);
        }

        if (state != null) {
            request.addPostParam("State", state.toString());
        }

        if (isAvailable != null) {
            request.addPostParam("IsAvailable", isAvailable.toString());
        }
    }
}