/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.insights.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class SettingUpdater extends Updater<Setting> {
    private Boolean advancedFeatures;
    private Boolean voiceTrace;
    private String subaccountSid;

    /**
     * The advanced_features.
     *
     * @param advancedFeatures The advanced_features
     * @return this
     */
    public SettingUpdater setAdvancedFeatures(final Boolean advancedFeatures) {
        this.advancedFeatures = advancedFeatures;
        return this;
    }

    /**
     * The voice_trace.
     *
     * @param voiceTrace The voice_trace
     * @return this
     */
    public SettingUpdater setVoiceTrace(final Boolean voiceTrace) {
        this.voiceTrace = voiceTrace;
        return this;
    }

    /**
     * The subaccount_sid.
     *
     * @param subaccountSid The subaccount_sid
     * @return this
     */
    public SettingUpdater setSubaccountSid(final String subaccountSid) {
        this.subaccountSid = subaccountSid;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Setting
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Setting update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.INSIGHTS.toString(),
            "/v1/Voice/Settings"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Setting update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Setting.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (advancedFeatures != null) {
            request.addPostParam("AdvancedFeatures", advancedFeatures.toString());
        }

        if (voiceTrace != null) {
            request.addPostParam("VoiceTrace", voiceTrace.toString());
        }

        if (subaccountSid != null) {
            request.addPostParam("SubaccountSid", subaccountSid);
        }
    }
}