/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.ipmessaging.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;
import java.util.List;

public class ServiceUpdater extends Updater<Service> {
    private final String pathSid;
    private String friendlyName;
    private String defaultServiceRoleSid;
    private String defaultChannelRoleSid;
    private String defaultChannelCreatorRoleSid;
    private Boolean readStatusEnabled;
    private Boolean reachabilityEnabled;
    private Integer typingIndicatorTimeout;
    private Integer consumptionReportInterval;
    private Boolean notificationsNewMessageEnabled;
    private String notificationsNewMessageTemplate;
    private Boolean notificationsAddedToChannelEnabled;
    private String notificationsAddedToChannelTemplate;
    private Boolean notificationsRemovedFromChannelEnabled;
    private String notificationsRemovedFromChannelTemplate;
    private Boolean notificationsInvitedToChannelEnabled;
    private String notificationsInvitedToChannelTemplate;
    private URI preWebhookUrl;
    private URI postWebhookUrl;
    private HttpMethod webhookMethod;
    private List<String> webhookFilters;
    private URI webhooksOnMessageSendUrl;
    private HttpMethod webhooksOnMessageSendMethod;
    private URI webhooksOnMessageUpdateUrl;
    private HttpMethod webhooksOnMessageUpdateMethod;
    private URI webhooksOnMessageRemoveUrl;
    private HttpMethod webhooksOnMessageRemoveMethod;
    private URI webhooksOnChannelAddUrl;
    private HttpMethod webhooksOnChannelAddMethod;
    private URI webhooksOnChannelDestroyUrl;
    private HttpMethod webhooksOnChannelDestroyMethod;
    private URI webhooksOnChannelUpdateUrl;
    private HttpMethod webhooksOnChannelUpdateMethod;
    private URI webhooksOnMemberAddUrl;
    private HttpMethod webhooksOnMemberAddMethod;
    private URI webhooksOnMemberRemoveUrl;
    private HttpMethod webhooksOnMemberRemoveMethod;
    private URI webhooksOnMessageSentUrl;
    private HttpMethod webhooksOnMessageSentMethod;
    private URI webhooksOnMessageUpdatedUrl;
    private HttpMethod webhooksOnMessageUpdatedMethod;
    private URI webhooksOnMessageRemovedUrl;
    private HttpMethod webhooksOnMessageRemovedMethod;
    private URI webhooksOnChannelAddedUrl;
    private HttpMethod webhooksOnChannelAddedMethod;
    private URI webhooksOnChannelDestroyedUrl;
    private HttpMethod webhooksOnChannelDestroyedMethod;
    private URI webhooksOnChannelUpdatedUrl;
    private HttpMethod webhooksOnChannelUpdatedMethod;
    private URI webhooksOnMemberAddedUrl;
    private HttpMethod webhooksOnMemberAddedMethod;
    private URI webhooksOnMemberRemovedUrl;
    private HttpMethod webhooksOnMemberRemovedMethod;
    private Integer limitsChannelMembers;
    private Integer limitsUserChannels;

    /**
     * Construct a new ServiceUpdater.
     *
     * @param pathSid The sid
     */
    public ServiceUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * The friendly_name.
     *
     * @param friendlyName The friendly_name
     * @return this
     */
    public ServiceUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The default_service_role_sid.
     *
     * @param defaultServiceRoleSid The default_service_role_sid
     * @return this
     */
    public ServiceUpdater setDefaultServiceRoleSid(final String defaultServiceRoleSid) {
        this.defaultServiceRoleSid = defaultServiceRoleSid;
        return this;
    }

    /**
     * The default_channel_role_sid.
     *
     * @param defaultChannelRoleSid The default_channel_role_sid
     * @return this
     */
    public ServiceUpdater setDefaultChannelRoleSid(final String defaultChannelRoleSid) {
        this.defaultChannelRoleSid = defaultChannelRoleSid;
        return this;
    }

    /**
     * The default_channel_creator_role_sid.
     *
     * @param defaultChannelCreatorRoleSid The default_channel_creator_role_sid
     * @return this
     */
    public ServiceUpdater setDefaultChannelCreatorRoleSid(final String defaultChannelCreatorRoleSid) {
        this.defaultChannelCreatorRoleSid = defaultChannelCreatorRoleSid;
        return this;
    }

    /**
     * The read_status_enabled.
     *
     * @param readStatusEnabled The read_status_enabled
     * @return this
     */
    public ServiceUpdater setReadStatusEnabled(final Boolean readStatusEnabled) {
        this.readStatusEnabled = readStatusEnabled;
        return this;
    }

    /**
     * The reachability_enabled.
     *
     * @param reachabilityEnabled The reachability_enabled
     * @return this
     */
    public ServiceUpdater setReachabilityEnabled(final Boolean reachabilityEnabled) {
        this.reachabilityEnabled = reachabilityEnabled;
        return this;
    }

    /**
     * The typing_indicator_timeout.
     *
     * @param typingIndicatorTimeout The typing_indicator_timeout
     * @return this
     */
    public ServiceUpdater setTypingIndicatorTimeout(final Integer typingIndicatorTimeout) {
        this.typingIndicatorTimeout = typingIndicatorTimeout;
        return this;
    }

    /**
     * The consumption_report_interval.
     *
     * @param consumptionReportInterval The consumption_report_interval
     * @return this
     */
    public ServiceUpdater setConsumptionReportInterval(final Integer consumptionReportInterval) {
        this.consumptionReportInterval = consumptionReportInterval;
        return this;
    }

    /**
     * The notifications.new_message.enabled.
     *
     * @param notificationsNewMessageEnabled The notifications.new_message.enabled
     * @return this
     */
    public ServiceUpdater setNotificationsNewMessageEnabled(final Boolean notificationsNewMessageEnabled) {
        this.notificationsNewMessageEnabled = notificationsNewMessageEnabled;
        return this;
    }

    /**
     * The notifications.new_message.template.
     *
     * @param notificationsNewMessageTemplate The notifications.new_message.template
     * @return this
     */
    public ServiceUpdater setNotificationsNewMessageTemplate(final String notificationsNewMessageTemplate) {
        this.notificationsNewMessageTemplate = notificationsNewMessageTemplate;
        return this;
    }

    /**
     * The notifications.added_to_channel.enabled.
     *
     * @param notificationsAddedToChannelEnabled The
     *                                           notifications.added_to_channel.enabled
     * @return this
     */
    public ServiceUpdater setNotificationsAddedToChannelEnabled(final Boolean notificationsAddedToChannelEnabled) {
        this.notificationsAddedToChannelEnabled = notificationsAddedToChannelEnabled;
        return this;
    }

    /**
     * The notifications.added_to_channel.template.
     *
     * @param notificationsAddedToChannelTemplate The
     *                                            notifications.added_to_channel.template
     * @return this
     */
    public ServiceUpdater setNotificationsAddedToChannelTemplate(final String notificationsAddedToChannelTemplate) {
        this.notificationsAddedToChannelTemplate = notificationsAddedToChannelTemplate;
        return this;
    }

    /**
     * The notifications.removed_from_channel.enabled.
     *
     * @param notificationsRemovedFromChannelEnabled The
     *                                               notifications.removed_from_channel.enabled
     * @return this
     */
    public ServiceUpdater setNotificationsRemovedFromChannelEnabled(final Boolean notificationsRemovedFromChannelEnabled) {
        this.notificationsRemovedFromChannelEnabled = notificationsRemovedFromChannelEnabled;
        return this;
    }

    /**
     * The notifications.removed_from_channel.template.
     *
     * @param notificationsRemovedFromChannelTemplate The
     *                                                notifications.removed_from_channel.template
     * @return this
     */
    public ServiceUpdater setNotificationsRemovedFromChannelTemplate(final String notificationsRemovedFromChannelTemplate) {
        this.notificationsRemovedFromChannelTemplate = notificationsRemovedFromChannelTemplate;
        return this;
    }

    /**
     * The notifications.invited_to_channel.enabled.
     *
     * @param notificationsInvitedToChannelEnabled The
     *                                             notifications.invited_to_channel.enabled
     * @return this
     */
    public ServiceUpdater setNotificationsInvitedToChannelEnabled(final Boolean notificationsInvitedToChannelEnabled) {
        this.notificationsInvitedToChannelEnabled = notificationsInvitedToChannelEnabled;
        return this;
    }

    /**
     * The notifications.invited_to_channel.template.
     *
     * @param notificationsInvitedToChannelTemplate The
     *                                              notifications.invited_to_channel.template
     * @return this
     */
    public ServiceUpdater setNotificationsInvitedToChannelTemplate(final String notificationsInvitedToChannelTemplate) {
        this.notificationsInvitedToChannelTemplate = notificationsInvitedToChannelTemplate;
        return this;
    }

    /**
     * The pre_webhook_url.
     *
     * @param preWebhookUrl The pre_webhook_url
     * @return this
     */
    public ServiceUpdater setPreWebhookUrl(final URI preWebhookUrl) {
        this.preWebhookUrl = preWebhookUrl;
        return this;
    }

    /**
     * The pre_webhook_url.
     *
     * @param preWebhookUrl The pre_webhook_url
     * @return this
     */
    public ServiceUpdater setPreWebhookUrl(final String preWebhookUrl) {
        return setPreWebhookUrl(Promoter.uriFromString(preWebhookUrl));
    }

    /**
     * The post_webhook_url.
     *
     * @param postWebhookUrl The post_webhook_url
     * @return this
     */
    public ServiceUpdater setPostWebhookUrl(final URI postWebhookUrl) {
        this.postWebhookUrl = postWebhookUrl;
        return this;
    }

    /**
     * The post_webhook_url.
     *
     * @param postWebhookUrl The post_webhook_url
     * @return this
     */
    public ServiceUpdater setPostWebhookUrl(final String postWebhookUrl) {
        return setPostWebhookUrl(Promoter.uriFromString(postWebhookUrl));
    }

    /**
     * The webhook_method.
     *
     * @param webhookMethod The webhook_method
     * @return this
     */
    public ServiceUpdater setWebhookMethod(final HttpMethod webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    /**
     * The webhook_filters.
     *
     * @param webhookFilters The webhook_filters
     * @return this
     */
    public ServiceUpdater setWebhookFilters(final List<String> webhookFilters) {
        this.webhookFilters = webhookFilters;
        return this;
    }

    /**
     * The webhook_filters.
     *
     * @param webhookFilters The webhook_filters
     * @return this
     */
    public ServiceUpdater setWebhookFilters(final String webhookFilters) {
        return setWebhookFilters(Promoter.listOfOne(webhookFilters));
    }

    /**
     * The webhooks.on_message_send.url.
     *
     * @param webhooksOnMessageSendUrl The webhooks.on_message_send.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageSendUrl(final URI webhooksOnMessageSendUrl) {
        this.webhooksOnMessageSendUrl = webhooksOnMessageSendUrl;
        return this;
    }

    /**
     * The webhooks.on_message_send.url.
     *
     * @param webhooksOnMessageSendUrl The webhooks.on_message_send.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageSendUrl(final String webhooksOnMessageSendUrl) {
        return setWebhooksOnMessageSendUrl(Promoter.uriFromString(webhooksOnMessageSendUrl));
    }

    /**
     * The webhooks.on_message_send.method.
     *
     * @param webhooksOnMessageSendMethod The webhooks.on_message_send.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageSendMethod(final HttpMethod webhooksOnMessageSendMethod) {
        this.webhooksOnMessageSendMethod = webhooksOnMessageSendMethod;
        return this;
    }

    /**
     * The webhooks.on_message_update.url.
     *
     * @param webhooksOnMessageUpdateUrl The webhooks.on_message_update.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageUpdateUrl(final URI webhooksOnMessageUpdateUrl) {
        this.webhooksOnMessageUpdateUrl = webhooksOnMessageUpdateUrl;
        return this;
    }

    /**
     * The webhooks.on_message_update.url.
     *
     * @param webhooksOnMessageUpdateUrl The webhooks.on_message_update.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageUpdateUrl(final String webhooksOnMessageUpdateUrl) {
        return setWebhooksOnMessageUpdateUrl(Promoter.uriFromString(webhooksOnMessageUpdateUrl));
    }

    /**
     * The webhooks.on_message_update.method.
     *
     * @param webhooksOnMessageUpdateMethod The webhooks.on_message_update.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageUpdateMethod(final HttpMethod webhooksOnMessageUpdateMethod) {
        this.webhooksOnMessageUpdateMethod = webhooksOnMessageUpdateMethod;
        return this;
    }

    /**
     * The webhooks.on_message_remove.url.
     *
     * @param webhooksOnMessageRemoveUrl The webhooks.on_message_remove.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageRemoveUrl(final URI webhooksOnMessageRemoveUrl) {
        this.webhooksOnMessageRemoveUrl = webhooksOnMessageRemoveUrl;
        return this;
    }

    /**
     * The webhooks.on_message_remove.url.
     *
     * @param webhooksOnMessageRemoveUrl The webhooks.on_message_remove.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageRemoveUrl(final String webhooksOnMessageRemoveUrl) {
        return setWebhooksOnMessageRemoveUrl(Promoter.uriFromString(webhooksOnMessageRemoveUrl));
    }

    /**
     * The webhooks.on_message_remove.method.
     *
     * @param webhooksOnMessageRemoveMethod The webhooks.on_message_remove.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageRemoveMethod(final HttpMethod webhooksOnMessageRemoveMethod) {
        this.webhooksOnMessageRemoveMethod = webhooksOnMessageRemoveMethod;
        return this;
    }

    /**
     * The webhooks.on_channel_add.url.
     *
     * @param webhooksOnChannelAddUrl The webhooks.on_channel_add.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelAddUrl(final URI webhooksOnChannelAddUrl) {
        this.webhooksOnChannelAddUrl = webhooksOnChannelAddUrl;
        return this;
    }

    /**
     * The webhooks.on_channel_add.url.
     *
     * @param webhooksOnChannelAddUrl The webhooks.on_channel_add.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelAddUrl(final String webhooksOnChannelAddUrl) {
        return setWebhooksOnChannelAddUrl(Promoter.uriFromString(webhooksOnChannelAddUrl));
    }

    /**
     * The webhooks.on_channel_add.method.
     *
     * @param webhooksOnChannelAddMethod The webhooks.on_channel_add.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelAddMethod(final HttpMethod webhooksOnChannelAddMethod) {
        this.webhooksOnChannelAddMethod = webhooksOnChannelAddMethod;
        return this;
    }

    /**
     * The webhooks.on_channel_destroy.url.
     *
     * @param webhooksOnChannelDestroyUrl The webhooks.on_channel_destroy.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelDestroyUrl(final URI webhooksOnChannelDestroyUrl) {
        this.webhooksOnChannelDestroyUrl = webhooksOnChannelDestroyUrl;
        return this;
    }

    /**
     * The webhooks.on_channel_destroy.url.
     *
     * @param webhooksOnChannelDestroyUrl The webhooks.on_channel_destroy.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelDestroyUrl(final String webhooksOnChannelDestroyUrl) {
        return setWebhooksOnChannelDestroyUrl(Promoter.uriFromString(webhooksOnChannelDestroyUrl));
    }

    /**
     * The webhooks.on_channel_destroy.method.
     *
     * @param webhooksOnChannelDestroyMethod The webhooks.on_channel_destroy.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelDestroyMethod(final HttpMethod webhooksOnChannelDestroyMethod) {
        this.webhooksOnChannelDestroyMethod = webhooksOnChannelDestroyMethod;
        return this;
    }

    /**
     * The webhooks.on_channel_update.url.
     *
     * @param webhooksOnChannelUpdateUrl The webhooks.on_channel_update.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelUpdateUrl(final URI webhooksOnChannelUpdateUrl) {
        this.webhooksOnChannelUpdateUrl = webhooksOnChannelUpdateUrl;
        return this;
    }

    /**
     * The webhooks.on_channel_update.url.
     *
     * @param webhooksOnChannelUpdateUrl The webhooks.on_channel_update.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelUpdateUrl(final String webhooksOnChannelUpdateUrl) {
        return setWebhooksOnChannelUpdateUrl(Promoter.uriFromString(webhooksOnChannelUpdateUrl));
    }

    /**
     * The webhooks.on_channel_update.method.
     *
     * @param webhooksOnChannelUpdateMethod The webhooks.on_channel_update.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelUpdateMethod(final HttpMethod webhooksOnChannelUpdateMethod) {
        this.webhooksOnChannelUpdateMethod = webhooksOnChannelUpdateMethod;
        return this;
    }

    /**
     * The webhooks.on_member_add.url.
     *
     * @param webhooksOnMemberAddUrl The webhooks.on_member_add.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberAddUrl(final URI webhooksOnMemberAddUrl) {
        this.webhooksOnMemberAddUrl = webhooksOnMemberAddUrl;
        return this;
    }

    /**
     * The webhooks.on_member_add.url.
     *
     * @param webhooksOnMemberAddUrl The webhooks.on_member_add.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberAddUrl(final String webhooksOnMemberAddUrl) {
        return setWebhooksOnMemberAddUrl(Promoter.uriFromString(webhooksOnMemberAddUrl));
    }

    /**
     * The webhooks.on_member_add.method.
     *
     * @param webhooksOnMemberAddMethod The webhooks.on_member_add.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberAddMethod(final HttpMethod webhooksOnMemberAddMethod) {
        this.webhooksOnMemberAddMethod = webhooksOnMemberAddMethod;
        return this;
    }

    /**
     * The webhooks.on_member_remove.url.
     *
     * @param webhooksOnMemberRemoveUrl The webhooks.on_member_remove.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberRemoveUrl(final URI webhooksOnMemberRemoveUrl) {
        this.webhooksOnMemberRemoveUrl = webhooksOnMemberRemoveUrl;
        return this;
    }

    /**
     * The webhooks.on_member_remove.url.
     *
     * @param webhooksOnMemberRemoveUrl The webhooks.on_member_remove.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberRemoveUrl(final String webhooksOnMemberRemoveUrl) {
        return setWebhooksOnMemberRemoveUrl(Promoter.uriFromString(webhooksOnMemberRemoveUrl));
    }

    /**
     * The webhooks.on_member_remove.method.
     *
     * @param webhooksOnMemberRemoveMethod The webhooks.on_member_remove.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberRemoveMethod(final HttpMethod webhooksOnMemberRemoveMethod) {
        this.webhooksOnMemberRemoveMethod = webhooksOnMemberRemoveMethod;
        return this;
    }

    /**
     * The webhooks.on_message_sent.url.
     *
     * @param webhooksOnMessageSentUrl The webhooks.on_message_sent.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageSentUrl(final URI webhooksOnMessageSentUrl) {
        this.webhooksOnMessageSentUrl = webhooksOnMessageSentUrl;
        return this;
    }

    /**
     * The webhooks.on_message_sent.url.
     *
     * @param webhooksOnMessageSentUrl The webhooks.on_message_sent.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageSentUrl(final String webhooksOnMessageSentUrl) {
        return setWebhooksOnMessageSentUrl(Promoter.uriFromString(webhooksOnMessageSentUrl));
    }

    /**
     * The webhooks.on_message_sent.method.
     *
     * @param webhooksOnMessageSentMethod The webhooks.on_message_sent.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageSentMethod(final HttpMethod webhooksOnMessageSentMethod) {
        this.webhooksOnMessageSentMethod = webhooksOnMessageSentMethod;
        return this;
    }

    /**
     * The webhooks.on_message_updated.url.
     *
     * @param webhooksOnMessageUpdatedUrl The webhooks.on_message_updated.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageUpdatedUrl(final URI webhooksOnMessageUpdatedUrl) {
        this.webhooksOnMessageUpdatedUrl = webhooksOnMessageUpdatedUrl;
        return this;
    }

    /**
     * The webhooks.on_message_updated.url.
     *
     * @param webhooksOnMessageUpdatedUrl The webhooks.on_message_updated.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageUpdatedUrl(final String webhooksOnMessageUpdatedUrl) {
        return setWebhooksOnMessageUpdatedUrl(Promoter.uriFromString(webhooksOnMessageUpdatedUrl));
    }

    /**
     * The webhooks.on_message_updated.method.
     *
     * @param webhooksOnMessageUpdatedMethod The webhooks.on_message_updated.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageUpdatedMethod(final HttpMethod webhooksOnMessageUpdatedMethod) {
        this.webhooksOnMessageUpdatedMethod = webhooksOnMessageUpdatedMethod;
        return this;
    }

    /**
     * The webhooks.on_message_removed.url.
     *
     * @param webhooksOnMessageRemovedUrl The webhooks.on_message_removed.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageRemovedUrl(final URI webhooksOnMessageRemovedUrl) {
        this.webhooksOnMessageRemovedUrl = webhooksOnMessageRemovedUrl;
        return this;
    }

    /**
     * The webhooks.on_message_removed.url.
     *
     * @param webhooksOnMessageRemovedUrl The webhooks.on_message_removed.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageRemovedUrl(final String webhooksOnMessageRemovedUrl) {
        return setWebhooksOnMessageRemovedUrl(Promoter.uriFromString(webhooksOnMessageRemovedUrl));
    }

    /**
     * The webhooks.on_message_removed.method.
     *
     * @param webhooksOnMessageRemovedMethod The webhooks.on_message_removed.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMessageRemovedMethod(final HttpMethod webhooksOnMessageRemovedMethod) {
        this.webhooksOnMessageRemovedMethod = webhooksOnMessageRemovedMethod;
        return this;
    }

    /**
     * The webhooks.on_channel_added.url.
     *
     * @param webhooksOnChannelAddedUrl The webhooks.on_channel_added.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelAddedUrl(final URI webhooksOnChannelAddedUrl) {
        this.webhooksOnChannelAddedUrl = webhooksOnChannelAddedUrl;
        return this;
    }

    /**
     * The webhooks.on_channel_added.url.
     *
     * @param webhooksOnChannelAddedUrl The webhooks.on_channel_added.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelAddedUrl(final String webhooksOnChannelAddedUrl) {
        return setWebhooksOnChannelAddedUrl(Promoter.uriFromString(webhooksOnChannelAddedUrl));
    }

    /**
     * The webhooks.on_channel_added.method.
     *
     * @param webhooksOnChannelAddedMethod The webhooks.on_channel_added.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelAddedMethod(final HttpMethod webhooksOnChannelAddedMethod) {
        this.webhooksOnChannelAddedMethod = webhooksOnChannelAddedMethod;
        return this;
    }

    /**
     * The webhooks.on_channel_destroyed.url.
     *
     * @param webhooksOnChannelDestroyedUrl The webhooks.on_channel_destroyed.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelDestroyedUrl(final URI webhooksOnChannelDestroyedUrl) {
        this.webhooksOnChannelDestroyedUrl = webhooksOnChannelDestroyedUrl;
        return this;
    }

    /**
     * The webhooks.on_channel_destroyed.url.
     *
     * @param webhooksOnChannelDestroyedUrl The webhooks.on_channel_destroyed.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelDestroyedUrl(final String webhooksOnChannelDestroyedUrl) {
        return setWebhooksOnChannelDestroyedUrl(Promoter.uriFromString(webhooksOnChannelDestroyedUrl));
    }

    /**
     * The webhooks.on_channel_destroyed.method.
     *
     * @param webhooksOnChannelDestroyedMethod The
     *                                         webhooks.on_channel_destroyed.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelDestroyedMethod(final HttpMethod webhooksOnChannelDestroyedMethod) {
        this.webhooksOnChannelDestroyedMethod = webhooksOnChannelDestroyedMethod;
        return this;
    }

    /**
     * The webhooks.on_channel_updated.url.
     *
     * @param webhooksOnChannelUpdatedUrl The webhooks.on_channel_updated.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelUpdatedUrl(final URI webhooksOnChannelUpdatedUrl) {
        this.webhooksOnChannelUpdatedUrl = webhooksOnChannelUpdatedUrl;
        return this;
    }

    /**
     * The webhooks.on_channel_updated.url.
     *
     * @param webhooksOnChannelUpdatedUrl The webhooks.on_channel_updated.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelUpdatedUrl(final String webhooksOnChannelUpdatedUrl) {
        return setWebhooksOnChannelUpdatedUrl(Promoter.uriFromString(webhooksOnChannelUpdatedUrl));
    }

    /**
     * The webhooks.on_channel_updated.method.
     *
     * @param webhooksOnChannelUpdatedMethod The webhooks.on_channel_updated.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnChannelUpdatedMethod(final HttpMethod webhooksOnChannelUpdatedMethod) {
        this.webhooksOnChannelUpdatedMethod = webhooksOnChannelUpdatedMethod;
        return this;
    }

    /**
     * The webhooks.on_member_added.url.
     *
     * @param webhooksOnMemberAddedUrl The webhooks.on_member_added.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberAddedUrl(final URI webhooksOnMemberAddedUrl) {
        this.webhooksOnMemberAddedUrl = webhooksOnMemberAddedUrl;
        return this;
    }

    /**
     * The webhooks.on_member_added.url.
     *
     * @param webhooksOnMemberAddedUrl The webhooks.on_member_added.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberAddedUrl(final String webhooksOnMemberAddedUrl) {
        return setWebhooksOnMemberAddedUrl(Promoter.uriFromString(webhooksOnMemberAddedUrl));
    }

    /**
     * The webhooks.on_member_added.method.
     *
     * @param webhooksOnMemberAddedMethod The webhooks.on_member_added.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberAddedMethod(final HttpMethod webhooksOnMemberAddedMethod) {
        this.webhooksOnMemberAddedMethod = webhooksOnMemberAddedMethod;
        return this;
    }

    /**
     * The webhooks.on_member_removed.url.
     *
     * @param webhooksOnMemberRemovedUrl The webhooks.on_member_removed.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberRemovedUrl(final URI webhooksOnMemberRemovedUrl) {
        this.webhooksOnMemberRemovedUrl = webhooksOnMemberRemovedUrl;
        return this;
    }

    /**
     * The webhooks.on_member_removed.url.
     *
     * @param webhooksOnMemberRemovedUrl The webhooks.on_member_removed.url
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberRemovedUrl(final String webhooksOnMemberRemovedUrl) {
        return setWebhooksOnMemberRemovedUrl(Promoter.uriFromString(webhooksOnMemberRemovedUrl));
    }

    /**
     * The webhooks.on_member_removed.method.
     *
     * @param webhooksOnMemberRemovedMethod The webhooks.on_member_removed.method
     * @return this
     */
    public ServiceUpdater setWebhooksOnMemberRemovedMethod(final HttpMethod webhooksOnMemberRemovedMethod) {
        this.webhooksOnMemberRemovedMethod = webhooksOnMemberRemovedMethod;
        return this;
    }

    /**
     * The limits.channel_members.
     *
     * @param limitsChannelMembers The limits.channel_members
     * @return this
     */
    public ServiceUpdater setLimitsChannelMembers(final Integer limitsChannelMembers) {
        this.limitsChannelMembers = limitsChannelMembers;
        return this;
    }

    /**
     * The limits.user_channels.
     *
     * @param limitsUserChannels The limits.user_channels
     * @return this
     */
    public ServiceUpdater setLimitsUserChannels(final Integer limitsUserChannels) {
        this.limitsUserChannels = limitsUserChannels;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Service
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Service update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.IPMESSAGING.toString(),
            "/v1/Services/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (defaultServiceRoleSid != null) {
            request.addPostParam("DefaultServiceRoleSid", defaultServiceRoleSid);
        }

        if (defaultChannelRoleSid != null) {
            request.addPostParam("DefaultChannelRoleSid", defaultChannelRoleSid);
        }

        if (defaultChannelCreatorRoleSid != null) {
            request.addPostParam("DefaultChannelCreatorRoleSid", defaultChannelCreatorRoleSid);
        }

        if (readStatusEnabled != null) {
            request.addPostParam("ReadStatusEnabled", readStatusEnabled.toString());
        }

        if (reachabilityEnabled != null) {
            request.addPostParam("ReachabilityEnabled", reachabilityEnabled.toString());
        }

        if (typingIndicatorTimeout != null) {
            request.addPostParam("TypingIndicatorTimeout", typingIndicatorTimeout.toString());
        }

        if (consumptionReportInterval != null) {
            request.addPostParam("ConsumptionReportInterval", consumptionReportInterval.toString());
        }

        if (notificationsNewMessageEnabled != null) {
            request.addPostParam("Notifications.NewMessage.Enabled", notificationsNewMessageEnabled.toString());
        }

        if (notificationsNewMessageTemplate != null) {
            request.addPostParam("Notifications.NewMessage.Template", notificationsNewMessageTemplate);
        }

        if (notificationsAddedToChannelEnabled != null) {
            request.addPostParam("Notifications.AddedToChannel.Enabled", notificationsAddedToChannelEnabled.toString());
        }

        if (notificationsAddedToChannelTemplate != null) {
            request.addPostParam("Notifications.AddedToChannel.Template", notificationsAddedToChannelTemplate);
        }

        if (notificationsRemovedFromChannelEnabled != null) {
            request.addPostParam("Notifications.RemovedFromChannel.Enabled", notificationsRemovedFromChannelEnabled.toString());
        }

        if (notificationsRemovedFromChannelTemplate != null) {
            request.addPostParam("Notifications.RemovedFromChannel.Template", notificationsRemovedFromChannelTemplate);
        }

        if (notificationsInvitedToChannelEnabled != null) {
            request.addPostParam("Notifications.InvitedToChannel.Enabled", notificationsInvitedToChannelEnabled.toString());
        }

        if (notificationsInvitedToChannelTemplate != null) {
            request.addPostParam("Notifications.InvitedToChannel.Template", notificationsInvitedToChannelTemplate);
        }

        if (preWebhookUrl != null) {
            request.addPostParam("PreWebhookUrl", preWebhookUrl.toString());
        }

        if (postWebhookUrl != null) {
            request.addPostParam("PostWebhookUrl", postWebhookUrl.toString());
        }

        if (webhookMethod != null) {
            request.addPostParam("WebhookMethod", webhookMethod.toString());
        }

        if (webhookFilters != null) {
            for (String prop : webhookFilters) {
                request.addPostParam("WebhookFilters", prop);
            }
        }

        if (webhooksOnMessageSendUrl != null) {
            request.addPostParam("Webhooks.OnMessageSend.Url", webhooksOnMessageSendUrl.toString());
        }

        if (webhooksOnMessageSendMethod != null) {
            request.addPostParam("Webhooks.OnMessageSend.Method", webhooksOnMessageSendMethod.toString());
        }

        if (webhooksOnMessageUpdateUrl != null) {
            request.addPostParam("Webhooks.OnMessageUpdate.Url", webhooksOnMessageUpdateUrl.toString());
        }

        if (webhooksOnMessageUpdateMethod != null) {
            request.addPostParam("Webhooks.OnMessageUpdate.Method", webhooksOnMessageUpdateMethod.toString());
        }

        if (webhooksOnMessageRemoveUrl != null) {
            request.addPostParam("Webhooks.OnMessageRemove.Url", webhooksOnMessageRemoveUrl.toString());
        }

        if (webhooksOnMessageRemoveMethod != null) {
            request.addPostParam("Webhooks.OnMessageRemove.Method", webhooksOnMessageRemoveMethod.toString());
        }

        if (webhooksOnChannelAddUrl != null) {
            request.addPostParam("Webhooks.OnChannelAdd.Url", webhooksOnChannelAddUrl.toString());
        }

        if (webhooksOnChannelAddMethod != null) {
            request.addPostParam("Webhooks.OnChannelAdd.Method", webhooksOnChannelAddMethod.toString());
        }

        if (webhooksOnChannelDestroyUrl != null) {
            request.addPostParam("Webhooks.OnChannelDestroy.Url", webhooksOnChannelDestroyUrl.toString());
        }

        if (webhooksOnChannelDestroyMethod != null) {
            request.addPostParam("Webhooks.OnChannelDestroy.Method", webhooksOnChannelDestroyMethod.toString());
        }

        if (webhooksOnChannelUpdateUrl != null) {
            request.addPostParam("Webhooks.OnChannelUpdate.Url", webhooksOnChannelUpdateUrl.toString());
        }

        if (webhooksOnChannelUpdateMethod != null) {
            request.addPostParam("Webhooks.OnChannelUpdate.Method", webhooksOnChannelUpdateMethod.toString());
        }

        if (webhooksOnMemberAddUrl != null) {
            request.addPostParam("Webhooks.OnMemberAdd.Url", webhooksOnMemberAddUrl.toString());
        }

        if (webhooksOnMemberAddMethod != null) {
            request.addPostParam("Webhooks.OnMemberAdd.Method", webhooksOnMemberAddMethod.toString());
        }

        if (webhooksOnMemberRemoveUrl != null) {
            request.addPostParam("Webhooks.OnMemberRemove.Url", webhooksOnMemberRemoveUrl.toString());
        }

        if (webhooksOnMemberRemoveMethod != null) {
            request.addPostParam("Webhooks.OnMemberRemove.Method", webhooksOnMemberRemoveMethod.toString());
        }

        if (webhooksOnMessageSentUrl != null) {
            request.addPostParam("Webhooks.OnMessageSent.Url", webhooksOnMessageSentUrl.toString());
        }

        if (webhooksOnMessageSentMethod != null) {
            request.addPostParam("Webhooks.OnMessageSent.Method", webhooksOnMessageSentMethod.toString());
        }

        if (webhooksOnMessageUpdatedUrl != null) {
            request.addPostParam("Webhooks.OnMessageUpdated.Url", webhooksOnMessageUpdatedUrl.toString());
        }

        if (webhooksOnMessageUpdatedMethod != null) {
            request.addPostParam("Webhooks.OnMessageUpdated.Method", webhooksOnMessageUpdatedMethod.toString());
        }

        if (webhooksOnMessageRemovedUrl != null) {
            request.addPostParam("Webhooks.OnMessageRemoved.Url", webhooksOnMessageRemovedUrl.toString());
        }

        if (webhooksOnMessageRemovedMethod != null) {
            request.addPostParam("Webhooks.OnMessageRemoved.Method", webhooksOnMessageRemovedMethod.toString());
        }

        if (webhooksOnChannelAddedUrl != null) {
            request.addPostParam("Webhooks.OnChannelAdded.Url", webhooksOnChannelAddedUrl.toString());
        }

        if (webhooksOnChannelAddedMethod != null) {
            request.addPostParam("Webhooks.OnChannelAdded.Method", webhooksOnChannelAddedMethod.toString());
        }

        if (webhooksOnChannelDestroyedUrl != null) {
            request.addPostParam("Webhooks.OnChannelDestroyed.Url", webhooksOnChannelDestroyedUrl.toString());
        }

        if (webhooksOnChannelDestroyedMethod != null) {
            request.addPostParam("Webhooks.OnChannelDestroyed.Method", webhooksOnChannelDestroyedMethod.toString());
        }

        if (webhooksOnChannelUpdatedUrl != null) {
            request.addPostParam("Webhooks.OnChannelUpdated.Url", webhooksOnChannelUpdatedUrl.toString());
        }

        if (webhooksOnChannelUpdatedMethod != null) {
            request.addPostParam("Webhooks.OnChannelUpdated.Method", webhooksOnChannelUpdatedMethod.toString());
        }

        if (webhooksOnMemberAddedUrl != null) {
            request.addPostParam("Webhooks.OnMemberAdded.Url", webhooksOnMemberAddedUrl.toString());
        }

        if (webhooksOnMemberAddedMethod != null) {
            request.addPostParam("Webhooks.OnMemberAdded.Method", webhooksOnMemberAddedMethod.toString());
        }

        if (webhooksOnMemberRemovedUrl != null) {
            request.addPostParam("Webhooks.OnMemberRemoved.Url", webhooksOnMemberRemovedUrl.toString());
        }

        if (webhooksOnMemberRemovedMethod != null) {
            request.addPostParam("Webhooks.OnMemberRemoved.Method", webhooksOnMemberRemovedMethod.toString());
        }

        if (limitsChannelMembers != null) {
            request.addPostParam("Limits.ChannelMembers", limitsChannelMembers.toString());
        }

        if (limitsUserChannels != null) {
            request.addPostParam("Limits.UserChannels", limitsUserChannels.toString());
        }
    }
}