/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.media.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class MediaProcessor extends Resource {
    private static final long serialVersionUID = 234389235546554L;

    public enum Status {
        FAILED("failed"),
        STARTED("started"),
        ENDED("ended");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum UpdateStatus {
        ENDED("ended");

        private final String value;

        private UpdateStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a UpdateStatus from a string.
         * @param value string value
         * @return generated UpdateStatus
         */
        @JsonCreator
        public static UpdateStatus forValue(final String value) {
            return Promoter.enumFromString(value, UpdateStatus.values());
        }
    }

    public enum Order {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private Order(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Order from a string.
         * @param value string value
         * @return generated Order
         */
        @JsonCreator
        public static Order forValue(final String value) {
            return Promoter.enumFromString(value, Order.values());
        }
    }

    /**
     * Create a MediaProcessorCreator to execute create.
     *
     * @param extension The Media Extension name or URL
     * @param extensionContext The Media Extension context
     * @return MediaProcessorCreator capable of executing the create
     */
    public static MediaProcessorCreator creator(final String extension,
                                                final String extensionContext) {
        return new MediaProcessorCreator(extension, extensionContext);
    }

    /**
     * Create a MediaProcessorFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @return MediaProcessorFetcher capable of executing the fetch
     */
    public static MediaProcessorFetcher fetcher(final String pathSid) {
        return new MediaProcessorFetcher(pathSid);
    }

    /**
     * Create a MediaProcessorUpdater to execute update.
     *
     * @param pathSid The SID that identifies the resource to update
     * @param status The status of the MediaProcessor
     * @return MediaProcessorUpdater capable of executing the update
     */
    public static MediaProcessorUpdater updater(final String pathSid,
                                                final MediaProcessor.UpdateStatus status) {
        return new MediaProcessorUpdater(pathSid, status);
    }

    /**
     * Create a MediaProcessorReader to execute read.
     *
     * @return MediaProcessorReader capable of executing the read
     */
    public static MediaProcessorReader reader() {
        return new MediaProcessorReader();
    }

    /**
     * Converts a JSON String into a MediaProcessor object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return MediaProcessor object represented by the provided JSON
     */
    public static MediaProcessor fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, MediaProcessor.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a MediaProcessor object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return MediaProcessor object represented by the provided JSON
     */
    public static MediaProcessor fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, MediaProcessor.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String extension;
    private final String extensionContext;
    private final MediaProcessor.Status status;
    private final URI url;
    private final String endedReason;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final Integer maxDuration;

    @JsonCreator
    private MediaProcessor(@JsonProperty("account_sid")
                           final String accountSid,
                           @JsonProperty("sid")
                           final String sid,
                           @JsonProperty("date_created")
                           final String dateCreated,
                           @JsonProperty("date_updated")
                           final String dateUpdated,
                           @JsonProperty("extension")
                           final String extension,
                           @JsonProperty("extension_context")
                           final String extensionContext,
                           @JsonProperty("status")
                           final MediaProcessor.Status status,
                           @JsonProperty("url")
                           final URI url,
                           @JsonProperty("ended_reason")
                           final String endedReason,
                           @JsonProperty("status_callback")
                           final URI statusCallback,
                           @JsonProperty("status_callback_method")
                           final HttpMethod statusCallbackMethod,
                           @JsonProperty("max_duration")
                           final Integer maxDuration) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.extension = extension;
        this.extensionContext = extensionContext;
        this.status = status;
        this.url = url;
        this.endedReason = endedReason;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.maxDuration = maxDuration;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The Media Extension name or URL.
     *
     * @return The Media Extension name or URL
     */
    public final String getExtension() {
        return this.extension;
    }

    /**
     * Returns The Media Extension context.
     *
     * @return The Media Extension context
     */
    public final String getExtensionContext() {
        return this.extensionContext;
    }

    /**
     * Returns The status of the MediaProcessor.
     *
     * @return The status of the MediaProcessor
     */
    public final MediaProcessor.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The reason why a MediaProcessor ended.
     *
     * @return The reason why a MediaProcessor ended
     */
    public final String getEndedReason() {
        return this.endedReason;
    }

    /**
     * Returns The URL to which Twilio will send MediaProcessor event updates.
     *
     * @return The URL to which Twilio will send MediaProcessor event updates
     */
    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    /**
     * Returns The HTTP method Twilio should use to call the `status_callback` URL.
     *
     * @return The HTTP method Twilio should use to call the `status_callback` URL
     */
    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    /**
     * Returns Maximum MediaProcessor duration in seconds.
     *
     * @return Maximum MediaProcessor duration in seconds
     */
    public final Integer getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        MediaProcessor other = (MediaProcessor) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(extension, other.extension) &&
               Objects.equals(extensionContext, other.extensionContext) &&
               Objects.equals(status, other.status) &&
               Objects.equals(url, other.url) &&
               Objects.equals(endedReason, other.endedReason) &&
               Objects.equals(statusCallback, other.statusCallback) &&
               Objects.equals(statusCallbackMethod, other.statusCallbackMethod) &&
               Objects.equals(maxDuration, other.maxDuration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            sid,
                            dateCreated,
                            dateUpdated,
                            extension,
                            extensionContext,
                            status,
                            url,
                            endedReason,
                            statusCallback,
                            statusCallbackMethod,
                            maxDuration);
    }
}