/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.media.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class MediaRecording extends Resource {
    private static final long serialVersionUID = 198699821184692L;

    public enum Format {
        MP4("mp4"),
        WEBM("webm");

        private final String value;

        private Format(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Format from a string.
         * @param value string value
         * @return generated Format
         */
        @JsonCreator
        public static Format forValue(final String value) {
            return Promoter.enumFromString(value, Format.values());
        }
    }

    public enum Order {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private Order(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Order from a string.
         * @param value string value
         * @return generated Order
         */
        @JsonCreator
        public static Order forValue(final String value) {
            return Promoter.enumFromString(value, Order.values());
        }
    }

    public enum Status {
        PROCESSING("processing"),
        COMPLETED("completed"),
        DELETED("deleted"),
        FAILED("failed");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        /**
         * Generate a Status from a string.
         * @param value string value
         * @return generated Status
         */
        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    /**
     * Create a MediaRecordingDeleter to execute delete.
     *
     * @param pathSid The SID that identifies the resource to delete
     * @return MediaRecordingDeleter capable of executing the delete
     */
    public static MediaRecordingDeleter deleter(final String pathSid) {
        return new MediaRecordingDeleter(pathSid);
    }

    /**
     * Create a MediaRecordingFetcher to execute fetch.
     *
     * @param pathSid The SID that identifies the resource to fetch
     * @return MediaRecordingFetcher capable of executing the fetch
     */
    public static MediaRecordingFetcher fetcher(final String pathSid) {
        return new MediaRecordingFetcher(pathSid);
    }

    /**
     * Create a MediaRecordingReader to execute read.
     *
     * @return MediaRecordingReader capable of executing the read
     */
    public static MediaRecordingReader reader() {
        return new MediaRecordingReader();
    }

    /**
     * Converts a JSON String into a MediaRecording object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return MediaRecording object represented by the provided JSON
     */
    public static MediaRecording fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, MediaRecording.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a MediaRecording object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return MediaRecording object represented by the provided JSON
     */
    public static MediaRecording fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, MediaRecording.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final Integer bitrate;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Integer duration;
    private final MediaRecording.Format format;
    private final Map<String, String> links;
    private final String processorSid;
    private final String resolution;
    private final String sourceSid;
    private final String sid;
    private final Long size;
    private final MediaRecording.Status status;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final URI url;

    @JsonCreator
    private MediaRecording(@JsonProperty("account_sid")
                           final String accountSid,
                           @JsonProperty("bitrate")
                           final Integer bitrate,
                           @JsonProperty("date_created")
                           final String dateCreated,
                           @JsonProperty("date_updated")
                           final String dateUpdated,
                           @JsonProperty("duration")
                           final Integer duration,
                           @JsonProperty("format")
                           final MediaRecording.Format format,
                           @JsonProperty("links")
                           final Map<String, String> links,
                           @JsonProperty("processor_sid")
                           final String processorSid,
                           @JsonProperty("resolution")
                           final String resolution,
                           @JsonProperty("source_sid")
                           final String sourceSid,
                           @JsonProperty("sid")
                           final String sid,
                           @JsonProperty("size")
                           final Long size,
                           @JsonProperty("status")
                           final MediaRecording.Status status,
                           @JsonProperty("status_callback")
                           final URI statusCallback,
                           @JsonProperty("status_callback_method")
                           final HttpMethod statusCallbackMethod,
                           @JsonProperty("url")
                           final URI url) {
        this.accountSid = accountSid;
        this.bitrate = bitrate;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.duration = duration;
        this.format = format;
        this.links = links;
        this.processorSid = processorSid;
        this.resolution = resolution;
        this.sourceSid = sourceSid;
        this.sid = sid;
        this.size = size;
        this.status = status;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.url = url;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The bitrate of the media.
     *
     * @return The bitrate of the media
     */
    public final Integer getBitrate() {
        return this.bitrate;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was last updated.
     *
     * @return The ISO 8601 date and time in GMT when the resource was last updated
     */
    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    /**
     * Returns The duration of the MediaRecording.
     *
     * @return The duration of the MediaRecording
     */
    public final Integer getDuration() {
        return this.duration;
    }

    /**
     * Returns The format of the MediaRecording.
     *
     * @return The format of the MediaRecording
     */
    public final MediaRecording.Format getFormat() {
        return this.format;
    }

    /**
     * Returns The URLs of related resources.
     *
     * @return The URLs of related resources
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    /**
     * Returns The SID of the MediaProcessor.
     *
     * @return The SID of the MediaProcessor
     */
    public final String getProcessorSid() {
        return this.processorSid;
    }

    /**
     * Returns The dimensions of the video image in pixels.
     *
     * @return The dimensions of the video image in pixels
     */
    public final String getResolution() {
        return this.resolution;
    }

    /**
     * Returns The SID of the resource that generated the original media.
     *
     * @return The SID of the resource that generated the original media
     */
    public final String getSourceSid() {
        return this.sourceSid;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The size of the recording.
     *
     * @return The size of the recording
     */
    public final Long getSize() {
        return this.size;
    }

    /**
     * Returns The status of the MediaRecording.
     *
     * @return The status of the MediaRecording
     */
    public final MediaRecording.Status getStatus() {
        return this.status;
    }

    /**
     * Returns The URL to which Twilio will send MediaRecording event updates.
     *
     * @return The URL to which Twilio will send MediaRecording event updates
     */
    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    /**
     * Returns The HTTP method Twilio should use to call the `status_callback` URL.
     *
     * @return The HTTP method Twilio should use to call the `status_callback` URL
     */
    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        MediaRecording other = (MediaRecording) o;

        return Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(bitrate, other.bitrate) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(dateUpdated, other.dateUpdated) &&
               Objects.equals(duration, other.duration) &&
               Objects.equals(format, other.format) &&
               Objects.equals(links, other.links) &&
               Objects.equals(processorSid, other.processorSid) &&
               Objects.equals(resolution, other.resolution) &&
               Objects.equals(sourceSid, other.sourceSid) &&
               Objects.equals(sid, other.sid) &&
               Objects.equals(size, other.size) &&
               Objects.equals(status, other.status) &&
               Objects.equals(statusCallback, other.statusCallback) &&
               Objects.equals(statusCallbackMethod, other.statusCallbackMethod) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid,
                            bitrate,
                            dateCreated,
                            dateUpdated,
                            duration,
                            format,
                            links,
                            processorSid,
                            resolution,
                            sourceSid,
                            sid,
                            size,
                            status,
                            statusCallback,
                            statusCallbackMethod,
                            url);
    }
}