/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.messaging.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class ExternalCampaignCreator extends Creator<ExternalCampaign> {
    private final String campaignId;
    private final String messagingServiceSid;

    /**
     * Construct a new ExternalCampaignCreator.
     *
     * @param campaignId ID of the preregistered campaign.
     * @param messagingServiceSid The SID of the Messaging Service the resource is
     *                            associated with
     */
    public ExternalCampaignCreator(final String campaignId,
                                   final String messagingServiceSid) {
        this.campaignId = campaignId;
        this.messagingServiceSid = messagingServiceSid;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created ExternalCampaign
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public ExternalCampaign create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.MESSAGING.toString(),
            "/v1/Services/PreregisteredUsa2p"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("ExternalCampaign creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return ExternalCampaign.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (campaignId != null) {
            request.addPostParam("CampaignId", campaignId);
        }

        if (messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", messagingServiceSid);
        }
    }
}