/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class UsAppToPersonFetcher extends Fetcher<UsAppToPerson> {
    private final String pathMessagingServiceSid;
    private final String pathSid;

    /**
     * Construct a new UsAppToPersonFetcher.
     *
     * @param pathMessagingServiceSid The SID of the Messaging Service to fetch the
     *                                resource from
     * @param pathSid The SID that identifies the US A2P Compliance resource to
     *                fetch
     */
    public UsAppToPersonFetcher(final String pathMessagingServiceSid,
                                final String pathSid) {
        this.pathMessagingServiceSid = pathMessagingServiceSid;
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched UsAppToPerson
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public UsAppToPerson fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.MESSAGING.toString(),
            "/v1/Services/" + this.pathMessagingServiceSid + "/Compliance/Usa2p/" + this.pathSid + ""
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("UsAppToPerson fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return UsAppToPerson.fromJson(response.getStream(), client.getObjectMapper());
    }
}