/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class UsAppToPersonUsecase extends Resource {
    private static final long serialVersionUID = 86502123471221L;

    /**
     * Create a UsAppToPersonUsecaseFetcher to execute fetch.
     *
     * @param pathMessagingServiceSid The SID of the Messaging Service to fetch the
     *                                resource from
     * @return UsAppToPersonUsecaseFetcher capable of executing the fetch
     */
    public static UsAppToPersonUsecaseFetcher fetcher(final String pathMessagingServiceSid) {
        return new UsAppToPersonUsecaseFetcher(pathMessagingServiceSid);
    }

    /**
     * Converts a JSON String into a UsAppToPersonUsecase object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return UsAppToPersonUsecase object represented by the provided JSON
     */
    public static UsAppToPersonUsecase fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, UsAppToPersonUsecase.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a UsAppToPersonUsecase object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return UsAppToPersonUsecase object represented by the provided JSON
     */
    public static UsAppToPersonUsecase fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, UsAppToPersonUsecase.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final List<Map<String, Object>> usAppToPersonUsecases;

    @JsonCreator
    private UsAppToPersonUsecase(@JsonProperty("us_app_to_person_usecases")
                                 final List<Map<String, Object>> usAppToPersonUsecases) {
        this.usAppToPersonUsecases = usAppToPersonUsecases;
    }

    /**
     * Returns Human readable A2P Use Case details.
     *
     * @return Human readable A2P Use Case details
     */
    public final List<Map<String, Object>> getUsAppToPersonUsecases() {
        return this.usAppToPersonUsecases;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UsAppToPersonUsecase other = (UsAppToPersonUsecase) o;

        return Objects.equals(usAppToPersonUsecases, other.usAppToPersonUsecases);
    }

    @Override
    public int hashCode() {
        return Objects.hash(usAppToPersonUsecases);
    }
}