/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.net.URI;

public class BundleUpdater extends Updater<Bundle> {
    private final String pathSid;
    private Bundle.Status status;
    private URI statusCallback;
    private String friendlyName;
    private String email;

    /**
     * Construct a new BundleUpdater.
     *
     * @param pathSid The unique string that identifies the resource.
     */
    public BundleUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    /**
     * The verification status of the Bundle resource..
     *
     * @param status The verification status of the Bundle resource
     * @return this
     */
    public BundleUpdater setStatus(final Bundle.Status status) {
        this.status = status;
        return this;
    }

    /**
     * The URL we call to inform your application of status changes..
     *
     * @param statusCallback The URL we call to inform your application of status
     *                       changes.
     * @return this
     */
    public BundleUpdater setStatusCallback(final URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    /**
     * The URL we call to inform your application of status changes..
     *
     * @param statusCallback The URL we call to inform your application of status
     *                       changes.
     * @return this
     */
    public BundleUpdater setStatusCallback(final String statusCallback) {
        return setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    /**
     * The string that you assigned to describe the resource..
     *
     * @param friendlyName The string that you assigned to describe the resource
     * @return this
     */
    public BundleUpdater setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    /**
     * The email address that will receive updates when the Bundle resource changes
     * status..
     *
     * @param email The email address
     * @return this
     */
    public BundleUpdater setEmail(final String email) {
        this.email = email;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Bundle
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Bundle update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.NUMBERS.toString(),
            "/v2/RegulatoryCompliance/Bundles/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Bundle update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Bundle.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (status != null) {
            request.addPostParam("Status", status.toString());
        }

        if (statusCallback != null) {
            request.addPostParam("StatusCallback", statusCallback.toString());
        }

        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }

        if (email != null) {
            request.addPostParam("Email", email);
        }
    }
}