/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ItemAssignment extends Resource {
    private static final long serialVersionUID = 155777674150989L;

    /**
     * Create a ItemAssignmentCreator to execute create.
     *
     * @param pathBundleSid The unique string that identifies the resource.
     * @param objectSid The sid of an object bag
     * @return ItemAssignmentCreator capable of executing the create
     */
    public static ItemAssignmentCreator creator(final String pathBundleSid,
                                                final String objectSid) {
        return new ItemAssignmentCreator(pathBundleSid, objectSid);
    }

    /**
     * Create a ItemAssignmentReader to execute read.
     *
     * @param pathBundleSid The unique string that identifies the resource.
     * @return ItemAssignmentReader capable of executing the read
     */
    public static ItemAssignmentReader reader(final String pathBundleSid) {
        return new ItemAssignmentReader(pathBundleSid);
    }

    /**
     * Create a ItemAssignmentFetcher to execute fetch.
     *
     * @param pathBundleSid The unique string that identifies the resource.
     * @param pathSid The unique string that identifies the resource
     * @return ItemAssignmentFetcher capable of executing the fetch
     */
    public static ItemAssignmentFetcher fetcher(final String pathBundleSid,
                                                final String pathSid) {
        return new ItemAssignmentFetcher(pathBundleSid, pathSid);
    }

    /**
     * Create a ItemAssignmentDeleter to execute delete.
     *
     * @param pathBundleSid The unique string that identifies the resource.
     * @param pathSid The unique string that identifies the resource
     * @return ItemAssignmentDeleter capable of executing the delete
     */
    public static ItemAssignmentDeleter deleter(final String pathBundleSid,
                                                final String pathSid) {
        return new ItemAssignmentDeleter(pathBundleSid, pathSid);
    }

    /**
     * Converts a JSON String into a ItemAssignment object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ItemAssignment object represented by the provided JSON
     */
    public static ItemAssignment fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ItemAssignment.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ItemAssignment object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ItemAssignment object represented by the provided JSON
     */
    public static ItemAssignment fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ItemAssignment.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String bundleSid;
    private final String accountSid;
    private final String objectSid;
    private final ZonedDateTime dateCreated;
    private final URI url;

    @JsonCreator
    private ItemAssignment(@JsonProperty("sid")
                           final String sid,
                           @JsonProperty("bundle_sid")
                           final String bundleSid,
                           @JsonProperty("account_sid")
                           final String accountSid,
                           @JsonProperty("object_sid")
                           final String objectSid,
                           @JsonProperty("date_created")
                           final String dateCreated,
                           @JsonProperty("url")
                           final URI url) {
        this.sid = sid;
        this.bundleSid = bundleSid;
        this.accountSid = accountSid;
        this.objectSid = objectSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The unique string that identifies the Bundle resource..
     *
     * @return The unique string that identifies the Bundle resource.
     */
    public final String getBundleSid() {
        return this.bundleSid;
    }

    /**
     * Returns The SID of the Account that created the resource.
     *
     * @return The SID of the Account that created the resource
     */
    public final String getAccountSid() {
        return this.accountSid;
    }

    /**
     * Returns The sid of an object bag.
     *
     * @return The sid of an object bag
     */
    public final String getObjectSid() {
        return this.objectSid;
    }

    /**
     * Returns The ISO 8601 date and time in GMT when the resource was created.
     *
     * @return The ISO 8601 date and time in GMT when the resource was created
     */
    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    /**
     * Returns The absolute URL of the Identity resource.
     *
     * @return The absolute URL of the Identity resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ItemAssignment other = (ItemAssignment) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(bundleSid, other.bundleSid) &&
               Objects.equals(accountSid, other.accountSid) &&
               Objects.equals(objectSid, other.objectSid) &&
               Objects.equals(dateCreated, other.dateCreated) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            bundleSid,
                            accountSid,
                            objectSid,
                            dateCreated,
                            url);
    }
}