/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.marketplace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class AvailableAddOn extends Resource {
    private static final long serialVersionUID = 22306216855466L;

    /**
     * Create a AvailableAddOnFetcher to execute fetch.
     *
     * @param pathSid The SID of the AvailableAddOn resource to fetch
     * @return AvailableAddOnFetcher capable of executing the fetch
     */
    public static AvailableAddOnFetcher fetcher(final String pathSid) {
        return new AvailableAddOnFetcher(pathSid);
    }

    /**
     * Create a AvailableAddOnReader to execute read.
     *
     * @return AvailableAddOnReader capable of executing the read
     */
    public static AvailableAddOnReader reader() {
        return new AvailableAddOnReader();
    }

    /**
     * Converts a JSON String into a AvailableAddOn object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return AvailableAddOn object represented by the provided JSON
     */
    public static AvailableAddOn fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AvailableAddOn.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a AvailableAddOn object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return AvailableAddOn object represented by the provided JSON
     */
    public static AvailableAddOn fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AvailableAddOn.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String friendlyName;
    private final String description;
    private final String pricingType;
    private final Map<String, Object> configurationSchema;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private AvailableAddOn(@JsonProperty("sid")
                           final String sid,
                           @JsonProperty("friendly_name")
                           final String friendlyName,
                           @JsonProperty("description")
                           final String description,
                           @JsonProperty("pricing_type")
                           final String pricingType,
                           @JsonProperty("configuration_schema")
                           final Map<String, Object> configurationSchema,
                           @JsonProperty("url")
                           final URI url,
                           @JsonProperty("links")
                           final Map<String, String> links) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.description = description;
        this.pricingType = pricingType;
        this.configurationSchema = configurationSchema;
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The unique string that identifies the resource.
     *
     * @return The unique string that identifies the resource
     */
    public final String getSid() {
        return this.sid;
    }

    /**
     * Returns The string that you assigned to describe the resource.
     *
     * @return The string that you assigned to describe the resource
     */
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    /**
     * Returns A short description of the Add-on's functionality.
     *
     * @return A short description of the Add-on's functionality
     */
    public final String getDescription() {
        return this.description;
    }

    /**
     * Returns How customers are charged for using this Add-on.
     *
     * @return How customers are charged for using this Add-on
     */
    public final String getPricingType() {
        return this.pricingType;
    }

    /**
     * Returns The JSON object with the configuration that must be provided when
     * installing a given Add-on.
     *
     * @return The JSON object with the configuration that must be provided when
     *         installing a given Add-on
     */
    public final Map<String, Object> getConfigurationSchema() {
        return this.configurationSchema;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns The URLs of related resources.
     *
     * @return The URLs of related resources
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AvailableAddOn other = (AvailableAddOn) o;

        return Objects.equals(sid, other.sid) &&
               Objects.equals(friendlyName, other.friendlyName) &&
               Objects.equals(description, other.description) &&
               Objects.equals(pricingType, other.pricingType) &&
               Objects.equals(configurationSchema, other.configurationSchema) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid,
                            friendlyName,
                            description,
                            pricingType,
                            configurationSchema,
                            url,
                            links);
    }
}