/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class BrandsInformation extends Resource {
    private static final long serialVersionUID = 89883061153774L;

    /**
     * Create a BrandsInformationFetcher to execute fetch.
     *
     * @return BrandsInformationFetcher capable of executing the fetch
     */
    public static BrandsInformationFetcher fetcher() {
        return new BrandsInformationFetcher();
    }

    /**
     * Converts a JSON String into a BrandsInformation object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return BrandsInformation object represented by the provided JSON
     */
    public static BrandsInformation fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandsInformation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a BrandsInformation object using the
     * provided ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return BrandsInformation object represented by the provided JSON
     */
    public static BrandsInformation fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandsInformation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final ZonedDateTime updateTime;
    private final URI fileLink;
    private final String fileLinkTtlInSeconds;
    private final URI url;

    @JsonCreator
    private BrandsInformation(@JsonProperty("update_time")
                              final String updateTime,
                              @JsonProperty("file_link")
                              final URI fileLink,
                              @JsonProperty("file_link_ttl_in_seconds")
                              final String fileLinkTtlInSeconds,
                              @JsonProperty("url")
                              final URI url) {
        this.updateTime = DateConverter.iso8601DateTimeFromString(updateTime);
        this.fileLink = fileLink;
        this.fileLinkTtlInSeconds = fileLinkTtlInSeconds;
        this.url = url;
    }

    /**
     * Returns Creation time of the information retrieved.
     *
     * @return Creation time of the information retrieved
     */
    public final ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    /**
     * Returns The URL to the brands information.
     *
     * @return The URL to the brands information
     */
    public final URI getFileLink() {
        return this.fileLink;
    }

    /**
     * Returns How long will be the `file_link` valid.
     *
     * @return How long will be the `file_link` valid
     */
    public final String getFileLinkTtlInSeconds() {
        return this.fileLinkTtlInSeconds;
    }

    /**
     * Returns The URL of this resource.
     *
     * @return The URL of this resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        BrandsInformation other = (BrandsInformation) o;

        return Objects.equals(updateTime, other.updateTime) &&
               Objects.equals(fileLink, other.fileLink) &&
               Objects.equals(fileLinkTtlInSeconds, other.fileLinkTtlInSeconds) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(updateTime,
                            fileLink,
                            fileLinkTtlInSeconds,
                            url);
    }
}