/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.util.Map;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
public class AssistantInitiationActionsUpdater extends Updater<AssistantInitiationActions> {
    private final String pathAssistantSid;
    private Map<String, Object> initiationActions;

    /**
     * Construct a new AssistantInitiationActionsUpdater.
     *
     * @param pathAssistantSid The assistant_sid
     */
    public AssistantInitiationActionsUpdater(final String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    /**
     * The initiation_actions.
     *
     * @param initiationActions The initiation_actions
     * @return this
     */
    public AssistantInitiationActionsUpdater setInitiationActions(final Map<String, Object> initiationActions) {
        this.initiationActions = initiationActions;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated AssistantInitiationActions
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public AssistantInitiationActions update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PREVIEW.toString(),
            "/understand/Assistants/" + this.pathAssistantSid + "/InitiationActions"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("AssistantInitiationActions update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return AssistantInitiationActions.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (initiationActions != null) {
            request.addPostParam("InitiationActions", Converter.mapToJson(initiationActions));
        }
    }
}