/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.pricing.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.type.InboundCallPrice;
import com.twilio.type.OutboundPrefixPriceWithOrigin;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Number extends Resource {
    private static final long serialVersionUID = 63150658787964L;

    /**
     * Create a NumberFetcher to execute fetch.
     *
     * @param pathDestinationNumber The destination number for which to fetch
     *                              pricing information
     * @return NumberFetcher capable of executing the fetch
     */
    public static NumberFetcher fetcher(final com.twilio.type.PhoneNumber pathDestinationNumber) {
        return new NumberFetcher(pathDestinationNumber);
    }

    /**
     * Converts a JSON String into a Number object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Number object represented by the provided JSON
     */
    public static Number fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Number.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Number object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Number object represented by the provided JSON
     */
    public static Number fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Number.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final com.twilio.type.PhoneNumber destinationNumber;
    private final com.twilio.type.PhoneNumber originationNumber;
    private final String country;
    private final String isoCountry;
    private final List<OutboundPrefixPriceWithOrigin> terminatingPrefixPrices;
    private final InboundCallPrice originatingCallPrice;
    private final Currency priceUnit;
    private final URI url;

    @JsonCreator
    private Number(@JsonProperty("destination_number")
                   final com.twilio.type.PhoneNumber destinationNumber,
                   @JsonProperty("origination_number")
                   final com.twilio.type.PhoneNumber originationNumber,
                   @JsonProperty("country")
                   final String country,
                   @JsonProperty("iso_country")
                   final String isoCountry,
                   @JsonProperty("terminating_prefix_prices")
                   final List<OutboundPrefixPriceWithOrigin> terminatingPrefixPrices,
                   @JsonProperty("originating_call_price")
                   final InboundCallPrice originatingCallPrice,
                   @JsonProperty("price_unit")
                   @JsonDeserialize(using = com.twilio.converter.CurrencyDeserializer.class)
                   final Currency priceUnit,
                   @JsonProperty("url")
                   final URI url) {
        this.destinationNumber = destinationNumber;
        this.originationNumber = originationNumber;
        this.country = country;
        this.isoCountry = isoCountry;
        this.terminatingPrefixPrices = terminatingPrefixPrices;
        this.originatingCallPrice = originatingCallPrice;
        this.priceUnit = priceUnit;
        this.url = url;
    }

    /**
     * Returns The destination phone number, in E.164 format.
     *
     * @return The destination phone number, in E.164 format
     */
    public final com.twilio.type.PhoneNumber getDestinationNumber() {
        return this.destinationNumber;
    }

    /**
     * Returns The origination phone number, in E.164 format.
     *
     * @return The origination phone number, in E.164 format
     */
    public final com.twilio.type.PhoneNumber getOriginationNumber() {
        return this.originationNumber;
    }

    /**
     * Returns The name of the country.
     *
     * @return The name of the country
     */
    public final String getCountry() {
        return this.country;
    }

    /**
     * Returns The ISO country code.
     *
     * @return The ISO country code
     */
    public final String getIsoCountry() {
        return this.isoCountry;
    }

    /**
     * Returns The terminating_prefix_prices.
     *
     * @return The terminating_prefix_prices
     */
    public final List<OutboundPrefixPriceWithOrigin> getTerminatingPrefixPrices() {
        return this.terminatingPrefixPrices;
    }

    /**
     * Returns The OriginatingCallPrice record.
     *
     * @return The OriginatingCallPrice record
     */
    public final InboundCallPrice getOriginatingCallPrice() {
        return this.originatingCallPrice;
    }

    /**
     * Returns The currency in which prices are measured, in ISO 4127 format (e.g.
     * usd, eur, jpy).
     *
     * @return The currency in which prices are measured, in ISO 4127 format (e.g.
     *         usd, eur, jpy)
     */
    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    /**
     * Returns The absolute URL of the resource.
     *
     * @return The absolute URL of the resource
     */
    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Number other = (Number) o;

        return Objects.equals(destinationNumber, other.destinationNumber) &&
               Objects.equals(originationNumber, other.originationNumber) &&
               Objects.equals(country, other.country) &&
               Objects.equals(isoCountry, other.isoCountry) &&
               Objects.equals(terminatingPrefixPrices, other.terminatingPrefixPrices) &&
               Objects.equals(originatingCallPrice, other.originatingCallPrice) &&
               Objects.equals(priceUnit, other.priceUnit) &&
               Objects.equals(url, other.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(destinationNumber,
                            originationNumber,
                            country,
                            isoCountry,
                            terminatingPrefixPrices,
                            originatingCallPrice,
                            priceUnit,
                            url);
    }
}