/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class PhoneNumberCreator extends Creator<PhoneNumber> {
    private final String pathServiceSid;
    private String sid;
    private com.twilio.type.PhoneNumber phoneNumber;
    private Boolean isReserved;

    /**
     * Construct a new PhoneNumberCreator.
     *
     * @param pathServiceSid The SID of the resource's parent Service
     */
    public PhoneNumberCreator(final String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    /**
     * The SID of a Twilio <a
     * href="https://www.twilio.com/docs/phone-numbers/api/incomingphonenumber-resource">IncomingPhoneNumber</a>
     * resource that represents the Twilio Number you would like to assign to your
     * Proxy Service..
     *
     * @param sid The SID of a Twilio IncomingPhoneNumber resource
     * @return this
     */
    public PhoneNumberCreator setSid(final String sid) {
        this.sid = sid;
        return this;
    }

    /**
     * The phone number in <a
     * href="https://www.twilio.com/docs/glossary/what-e164">E.164</a> format.
     * E.164 phone numbers consist of a + followed by the country code and
     * subscriber number without punctuation characters. For example, +14155551234..
     *
     * @param phoneNumber The phone number in E.164 format
     * @return this
     */
    public PhoneNumberCreator setPhoneNumber(final com.twilio.type.PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * The phone number in <a
     * href="https://www.twilio.com/docs/glossary/what-e164">E.164</a> format.
     * E.164 phone numbers consist of a + followed by the country code and
     * subscriber number without punctuation characters. For example, +14155551234..
     *
     * @param phoneNumber The phone number in E.164 format
     * @return this
     */
    public PhoneNumberCreator setPhoneNumber(final String phoneNumber) {
        return setPhoneNumber(Promoter.phoneNumberFromString(phoneNumber));
    }

    /**
     * Whether the new phone number should be reserved and not be assigned to a
     * participant using proxy pool logic. See <a
     * href="https://www.twilio.com/docs/proxy/reserved-phone-numbers">Reserved
     * Phone Numbers</a> for more information..
     *
     * @param isReserved Whether the new phone number should be reserved
     * @return this
     */
    public PhoneNumberCreator setIsReserved(final Boolean isReserved) {
        this.isReserved = isReserved;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created PhoneNumber
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public PhoneNumber create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PROXY.toString(),
            "/v1/Services/" + this.pathServiceSid + "/PhoneNumbers"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("PhoneNumber creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return PhoneNumber.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (sid != null) {
            request.addPostParam("Sid", sid);
        }

        if (phoneNumber != null) {
            request.addPostParam("PhoneNumber", phoneNumber.toString());
        }

        if (isReserved != null) {
            request.addPostParam("IsReserved", isReserved.toString());
        }
    }
}