/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Updater;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

import java.time.ZonedDateTime;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class SessionUpdater extends Updater<Session> {
    private final String pathServiceSid;
    private final String pathSid;
    private ZonedDateTime dateExpiry;
    private Integer ttl;
    private Session.Status status;
    private Boolean failOnParticipantConflict;

    /**
     * Construct a new SessionUpdater.
     *
     * @param pathServiceSid The SID of the Service to update the resource from
     * @param pathSid The unique string that identifies the resource
     */
    public SessionUpdater(final String pathServiceSid,
                          final String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    /**
     * The <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> date when
     * the Session should expire. If this is value is present, it overrides the
     * `ttl` value..
     *
     * @param dateExpiry The ISO 8601 date when the Session should expire
     * @return this
     */
    public SessionUpdater setDateExpiry(final ZonedDateTime dateExpiry) {
        this.dateExpiry = dateExpiry;
        return this;
    }

    /**
     * The time, in seconds, when the session will expire. The time is measured from
     * the last Session create or the Session's last Interaction..
     *
     * @param ttl When the session will expire
     * @return this
     */
    public SessionUpdater setTtl(final Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    /**
     * The new status of the resource. Can be: `in-progress` to re-open a session or
     * `closed` to close a session..
     *
     * @param status The new status of the resource
     * @return this
     */
    public SessionUpdater setStatus(final Session.Status status) {
        this.status = status;
        return this;
    }

    /**
     * [Experimental] For accounts with the ProxyAllowParticipantConflict account
     * flag, setting to true enables per-request opt-in to allowing Proxy to return
     * a 400 error (Twilio error code 80604) when a request to set a Session to
     * in-progress would cause Participants with the same Identifier/ProxyIdentifier
     * pair to be active in multiple Sessions. If not provided, requests will be
     * allowed to succeed, and a Debugger notification (80801) will be emitted.
     * Having multiple, active Participants with the same Identifier/ProxyIdentifier
     * pair causes calls and messages from affected Participants to be routed
     * incorrectly. Please note, the default behavior for accounts without the
     * ProxyAllowParticipantConflict flag is to reject the request as described.
     * This will eventually be the default for all accounts..
     *
     * @param failOnParticipantConflict An experimental parameter to override the
     *                                  ProxyAllowParticipantConflict account flag
     *                                  on a per-request basis.
     * @return this
     */
    public SessionUpdater setFailOnParticipantConflict(final Boolean failOnParticipantConflict) {
        this.failOnParticipantConflict = failOnParticipantConflict;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the update.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Updated Session
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Session update(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.PROXY.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Sessions/" + this.pathSid + ""
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Session update failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Session.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (dateExpiry != null) {
            request.addPostParam("DateExpiry", dateExpiry.toInstant().toString());
        }

        if (ttl != null) {
            request.addPostParam("Ttl", ttl.toString());
        }

        if (status != null) {
            request.addPostParam("Status", status.toString());
        }

        if (failOnParticipantConflict != null) {
            request.addPostParam("FailOnParticipantConflict", failOnParticipantConflict.toString());
        }
    }
}