/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.serverless.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class EnvironmentCreator extends Creator<Environment> {
    private final String pathServiceSid;
    private final String uniqueName;
    private String domainSuffix;

    /**
     * Construct a new EnvironmentCreator.
     *
     * @param pathServiceSid The SID of the Service to create the Environment
     *                       resource under
     * @param uniqueName A user-defined string that uniquely identifies the
     *                   Environment resource
     */
    public EnvironmentCreator(final String pathServiceSid,
                              final String uniqueName) {
        this.pathServiceSid = pathServiceSid;
        this.uniqueName = uniqueName;
    }

    /**
     * A URL-friendly name that represents the environment and forms part of the
     * domain name. It can be a maximum of 16 characters..
     *
     * @param domainSuffix A URL-friendly name that represents the environment
     * @return this
     */
    public EnvironmentCreator setDomainSuffix(final String domainSuffix) {
        this.domainSuffix = domainSuffix;
        return this;
    }

    /**
     * Make the request to the Twilio API to perform the create.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Created Environment
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public Environment create(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.POST,
            Domains.SERVERLESS.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Environments"
        );

        addPostParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("Environment creation failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return Environment.fromJson(response.getStream(), client.getObjectMapper());
    }

    /**
     * Add the requested post parameters to the Request.
     *
     * @param request Request to add post params to
     */
    private void addPostParams(final Request request) {
        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }

        if (domainSuffix != null) {
            request.addPostParam("DomainSuffix", domainSuffix);
        }
    }
}