/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.serverless.v1.service.build;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

/**
 * PLEASE NOTE that this class contains beta products that are subject to
 * change. Use them with caution.
 */
public class BuildStatusFetcher extends Fetcher<BuildStatus> {
    private final String pathServiceSid;
    private final String pathSid;

    /**
     * Construct a new BuildStatusFetcher.
     *
     * @param pathServiceSid The SID of the Service to fetch the Build resource from
     * @param pathSid The SID of the Build resource to fetch
     */
    public BuildStatusFetcher(final String pathServiceSid,
                              final String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    /**
     * Make the request to the Twilio API to perform the fetch.
     *
     * @param client TwilioRestClient with which to make the request
     * @return Fetched BuildStatus
     */
    @Override
    @SuppressWarnings("checkstyle:linelength")
    public BuildStatus fetch(final TwilioRestClient client) {
        Request request = new Request(
            HttpMethod.GET,
            Domains.SERVERLESS.toString(),
            "/v1/Services/" + this.pathServiceSid + "/Builds/" + this.pathSid + "/Status"
        );

        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException("BuildStatus fetch failed: Unable to connect to server");
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }

        return BuildStatus.fromJson(response.getStream(), client.getObjectMapper());
    }
}